/*
 * Decompiled with CFR 0.152.
 */
package requious.entity.spark;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import requious.entity.EntitySpark;
import requious.entity.ISparkTarget;
import requious.tile.ISparkAcceptor;

public class TargetTile
implements ISparkTarget {
    BlockPos pos;

    private TargetTile() {
    }

    public TargetTile(BlockPos pos) {
        this.pos = pos;
    }

    public TargetTile(TileEntity tile) {
        this.pos = tile.func_174877_v();
    }

    @Override
    public ISparkAcceptor getAcceptor(EntitySpark spark) {
        TileEntity tile = spark.func_130014_f_().func_175625_s(this.pos);
        if (tile instanceof ISparkAcceptor) {
            return (ISparkAcceptor)tile;
        }
        return null;
    }

    @Override
    public Vec3d getPosition(EntitySpark spark) {
        TileEntity tile = spark.func_130014_f_().func_175625_s(this.pos);
        if (tile != null) {
            BlockPos pos = tile.func_174877_v();
            return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        return Vec3d.field_186680_a;
    }

    @Override
    public boolean isValid(EntitySpark spark) {
        TileEntity tile = spark.func_130014_f_().func_175625_s(this.pos);
        return tile != null && !tile.func_145837_r();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("tileX", this.pos.func_177958_n());
        compound.func_74768_a("tileY", this.pos.func_177956_o());
        compound.func_74768_a("tileZ", this.pos.func_177952_p());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.pos = new BlockPos(compound.func_74762_e("tileX"), compound.func_74762_e("tileY"), compound.func_74762_e("tileZ"));
    }

    public static class Deserializer
    implements ISparkTarget.Deserializer {
        @Override
        public ISparkTarget deserialize(NBTTagCompound compound) {
            if (compound.func_74764_b("tileX")) {
                return new TargetTile();
            }
            return null;
        }
    }
}

