/*
 * Decompiled with CFR 0.152.
 */
package requious.data;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.crafttweaker.ColorCT;
import requious.compat.crafttweaker.IFluidCondition;
import requious.data.ItemData;
import requious.item.ItemFluidCell;
import requious.util.color.FluidColor;
import requious.util.color.ICustomColor;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.FluidCell")
public class FluidCellData
extends ItemData {
    @SerializedName(value="generateSubItems")
    public boolean generateSubItems;
    @SerializedName(value="capacity")
    public int capacity;
    @SerializedName(value="minInput")
    public int minInput = 0;
    @SerializedName(value="maxInput")
    public int maxInput = Integer.MAX_VALUE;
    @SerializedName(value="minOutput")
    public int minOutput = 0;
    @SerializedName(value="maxOutput")
    public int maxOutput = Integer.MAX_VALUE;
    @SerializedName(value="showTooltip")
    public boolean showToolip = true;
    @Expose(serialize=false, deserialize=false)
    public transient IFluidCondition filter;
    @Expose(serialize=false, deserialize=false)
    public transient ICustomColor barColor;
    @Expose(serialize=false, deserialize=false)
    public transient List<FuelData> fuelValues = new ArrayList<FuelData>();
    @Expose(serialize=false, deserialize=false)
    private transient ItemFluidCell item;

    public FluidCellData() {
        this.setBaseColor(new FluidColor());
    }

    public ItemFluidCell getItem() {
        return this.item;
    }

    public void setItem(ItemFluidCell item) {
        this.item = item;
    }

    @ZenMethod
    public void addFilter(IFluidCondition filter) {
        this.filter = filter;
    }

    @ZenMethod
    public void showBar(ColorCT color) {
        this.barColor = color.get();
    }

    @ZenMethod
    public void addFuelValue(ILiquidStack liquid, int value) {
        FluidStack fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)liquid);
        this.fuelValues.add(new FuelData(fluid, value));
    }

    public boolean hasBar() {
        return this.barColor != null;
    }

    public int getFuelValue(FluidStack fluid) {
        for (FuelData fuelData : this.fuelValues) {
            if (!fuelData.matches(fluid)) continue;
            int units = fluid.amount / fuelData.getUnit();
            return units * fuelData.getFuel();
        }
        return -1;
    }

    static class FuelData {
        FluidStack fluidStack;
        int fuel;

        public FuelData(FluidStack fluidStack, int fuel) {
            this.fluidStack = fluidStack;
            this.fuel = fuel;
        }

        public boolean matches(FluidStack check) {
            return this.fluidStack.isFluidEqual(check);
        }

        public int getUnit() {
            return this.fluidStack.amount;
        }

        public int getFuel() {
            return this.fuel;
        }
    }
}

