/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.crafttweaker.IWorldFunction;
import requious.compat.crafttweaker.LaserVisualCT;
import requious.compat.crafttweaker.MachineContainer;
import requious.compat.crafttweaker.RandomCT;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.recipe.ResultBase;
import requious.recipe.ResultEnergy;
import requious.recipe.ResultFluid;
import requious.recipe.ResultItem;
import requious.recipe.ResultJEI;
import requious.recipe.ResultLaser;
import requious.recipe.ResultWorld;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.RecipeContainer")
public class RecipeContainer {
    public Map<String, Object> inputs = new HashMap<String, Object>();
    public List<ResultBase> outputs = new ArrayList<ResultBase>();
    public MachineContainer container;
    public boolean jei;

    public RecipeContainer(MachineContainer container) {
        this.container = container;
    }

    public RecipeContainer(boolean jei) {
        this.jei = jei;
    }

    public void addInput(String mark, ItemStack object) {
        this.inputs.put(mark, object);
    }

    public void addInput(String mark, FluidStack object) {
        this.inputs.put(mark, object);
    }

    public void addInput(String mark, int object) {
        this.inputs.put(mark, object);
    }

    public List<ResultBase> getResults() {
        return this.outputs;
    }

    @ZenGetter(value="machine")
    public MachineContainer getContainer() {
        return this.container;
    }

    @ZenGetter(value="random")
    public RandomCT getRandom() {
        return this.container.getRandom();
    }

    @ZenGetter(value="jei")
    public boolean isJEI() {
        return this.jei;
    }

    @ZenMethod
    public void addItemOutput(String group, IItemStack istack) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)istack);
        this.outputs.add(new ResultItem(group, stack));
    }

    @ZenMethod
    public void addItemOutput(String group, IItemStack istack, int minInsert) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)istack);
        this.outputs.add(new ResultItem(group, stack, minInsert));
    }

    @ZenMethod
    public void addFluidOutput(String group, ILiquidStack istack) {
        FluidStack stack = CraftTweakerMC.getLiquidStack((ILiquidStack)istack);
        this.outputs.add(new ResultFluid(group, stack));
    }

    @ZenMethod
    public void addFluidOutput(String group, ILiquidStack istack, int minInsert) {
        FluidStack stack = CraftTweakerMC.getLiquidStack((ILiquidStack)istack);
        this.outputs.add(new ResultFluid(group, stack, minInsert));
    }

    @ZenMethod
    public void addEnergyOutput(String group, int energy) {
        this.outputs.add(new ResultEnergy(group, energy));
    }

    @ZenMethod
    public void addEnergyOutput(String group, int energy, int minInsert) {
        this.outputs.add(new ResultEnergy(group, energy, minInsert));
    }

    @ZenMethod
    public void addLaserOutput(String group, String type, int amount, LaserVisualCT visual, @Optional SlotVisualCT slotVisual) {
        this.outputs.add(new ResultLaser(group, type, amount, visual.get(), SlotVisualCT.unpack(slotVisual)));
    }

    @ZenMethod
    public void addWorldOutput(IWorldFunction function) {
        this.outputs.add(new ResultWorld(function));
    }

    @ZenMethod
    public void addJEIInfo(String group, String langKey, SlotVisualCT slotVisual) {
        this.outputs.add(new ResultJEI(group, langKey, SlotVisualCT.unpack(slotVisual)));
    }

    @ZenMethod
    public IItemStack getItem(String mark) {
        ItemStack stack = (ItemStack)this.inputs.getOrDefault(mark, ItemStack.field_190927_a);
        return CraftTweakerMC.getIItemStack((ItemStack)stack);
    }

    @ZenMethod
    public ILiquidStack getFluid(String mark) {
        FluidStack stack = this.inputs.getOrDefault(mark, null);
        return CraftTweakerMC.getILiquidStack((FluidStack)stack);
    }

    @ZenMethod
    public int getEnergy(String mark) {
        return (Integer)this.inputs.getOrDefault(mark, 0);
    }
}

