/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core.world;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.dimdev.jeid.INewChunk;
import org.dimdev.jeid.biome.BiomeError;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public class MixinChunk
implements INewChunk {
    @Unique
    private static final byte ERROR_BIOME_ID = (byte)Biome.field_185377_q.func_148757_b((Object)BiomeError.getInstance());
    @Unique
    private static final byte[] EMPTY_BLOCK_BIOME_ARRAY = new byte[256];
    @Unique
    private final int[] intBiomeArray = MixinChunk.generateIntBiomeArray();

    @Unique
    private static int[] generateIntBiomeArray() {
        int[] arr = new int[256];
        Arrays.fill(arr, -1);
        return arr;
    }

    @Override
    public int[] getIntBiomeArray() {
        return this.intBiomeArray;
    }

    @Override
    public void setIntBiomeArray(int[] intBiomeArray) {
        System.arraycopy(intBiomeArray, 0, this.intBiomeArray, 0, this.intBiomeArray.length);
    }

    @Inject(method={"getBiomeArray"}, at={@At(value="RETURN")}, cancellable=true)
    private void reid$returnErrorBiomeArray(CallbackInfoReturnable<byte[]> cir) {
        byte[] arr = new byte[256];
        Arrays.fill(arr, ERROR_BIOME_ID);
        cir.setReturnValue((Object)arr);
    }

    @ModifyVariable(method={"getBiome"}, at=@At(value="STORE", ordinal=0), name={"k"})
    @Dynamic(value="Read biome id from int biome array to int k")
    private int reid$fromIntBiomeArray(int original, @Local(name={"i"}) int i, @Local(name={"j"}) int j) {
        return this.intBiomeArray[j << 4 | i];
    }

    @ModifyConstant(method={"getBiome"}, constant={@Constant(intValue=255, ordinal=1)})
    private int reid$modifyDefaultId(int original) {
        return -1;
    }

    @Inject(method={"getBiome"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/biome/Biome;getIdForBiome(Lnet/minecraft/world/biome/Biome;)I")})
    private void reid$toIntBiomeArray(CallbackInfoReturnable<Biome> cir, @Local(name={"i"}) int i, @Local(name={"j"}) int j, @Local(name={"k"}) int k) {
        this.intBiomeArray[j << 4 | i] = k;
    }

    @Redirect(method={"getBiome"}, at=@At(value="FIELD", target="Lnet/minecraft/world/chunk/Chunk;blockBiomeArray:[B", opcode=180, ordinal=1))
    private byte[] reid$defaultWriteBiomeArray(Chunk instance) {
        return EMPTY_BLOCK_BIOME_ARRAY;
    }
}

