/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core.world;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.NibbleArray;
import org.dimdev.jeid.ducks.INewBlockStateContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockStateContainer.class})
public abstract class MixinBlockStateContainer
implements INewBlockStateContainer {
    @Unique
    private int[] temporaryPalette;
    @Unique
    private NibbleArray add2;

    @Shadow
    protected abstract IBlockState func_186015_a(int var1);

    @Shadow
    protected abstract void func_186014_b(int var1, IBlockState var2);

    @Override
    public int[] getTemporaryPalette() {
        return this.temporaryPalette;
    }

    @Override
    public void setTemporaryPalette(int[] temporaryPalette) {
        this.temporaryPalette = temporaryPalette;
    }

    @Override
    public void setLegacyAdd2(NibbleArray add2) {
        this.add2 = add2;
    }

    @Inject(method={"getDataForNBT"}, at={@At(value="HEAD")}, cancellable=true)
    private void reid$newGetDataForNBT(byte[] blockIds, NibbleArray data, CallbackInfoReturnable<NibbleArray> cir) {
        Reference2IntOpenHashMap stateIDMap = new Reference2IntOpenHashMap();
        int nextID = 0;
        for (int index = 0; index < 4096; ++index) {
            IBlockState state = this.func_186015_a(index);
            int paletteID = (Integer)stateIDMap.getOrDefault((Object)state, (Object)-1);
            if (paletteID == -1) {
                paletteID = nextID++;
                stateIDMap.put((Object)state, paletteID);
            }
            int x = index & 0xF;
            int y = index >> 8 & 0xF;
            int z = index >> 4 & 0xF;
            blockIds[index] = (byte)(paletteID >> 4 & 0xFF);
            data.func_76581_a(x, y, z, paletteID & 0xF);
        }
        this.temporaryPalette = new int[nextID];
        for (Reference2IntMap.Entry entry : stateIDMap.reference2IntEntrySet()) {
            this.temporaryPalette[entry.getIntValue()] = Block.field_176229_d.func_148747_b(entry.getKey());
        }
        cir.setReturnValue(null);
        cir.cancel();
    }

    @Inject(method={"setDataFromNBT"}, at={@At(value="HEAD")}, cancellable=true)
    private void reid$newSetDataFromNBT(byte[] blockIds, NibbleArray data, NibbleArray blockIdExtension, CallbackInfo ci) {
        if (this.temporaryPalette == null) {
            for (int index = 0; index < 4096; ++index) {
                int id;
                int toAdd;
                int x = index & 0xF;
                int y = index >> 8 & 0xF;
                int z = index >> 4 & 0xF;
                int n = toAdd = blockIdExtension == null ? 0 : blockIdExtension.func_76582_a(x, y, z);
                if (this.add2 != null) {
                    toAdd = toAdd & 0xF | this.add2.func_76582_a(x, y, z) << 4;
                }
                IBlockState bs = (id = toAdd << 12 | (blockIds[index] & 0xFF) << 4 | data.func_76582_a(x, y, z) & 0xF) == 0 ? Blocks.field_150350_a.func_176223_P() : (IBlockState)Block.field_176229_d.func_148745_a(id);
                this.func_186014_b(index, bs);
            }
        } else {
            for (int index = 0; index < 4096; ++index) {
                int x = index & 0xF;
                int y = index >> 8 & 0xF;
                int z = index >> 4 & 0xF;
                int paletteID = (blockIds[index] & 0xFF) << 4 | data.func_76582_a(x, y, z);
                this.func_186014_b(index, (IBlockState)Block.field_176229_d.func_148745_a(this.temporaryPalette[paletteID]));
            }
            this.temporaryPalette = null;
        }
        ci.cancel();
    }
}

