/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core.world;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.dimdev.jeid.ducks.INewBlockStateContainer;
import org.dimdev.jeid.ducks.INewChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public class MixinAnvilChunkLoader {
    @Inject(method={"readChunkFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getByteArray(Ljava/lang/String;)[B", ordinal=0)})
    private void reid$readPaletteNBT(CallbackInfoReturnable<Chunk> cir, @Local(ordinal=1) NBTTagCompound storageNBT, @Local ExtendedBlockStorage extendedBlockStorage) {
        int[] palette = storageNBT.func_150297_b("Palette", 11) ? storageNBT.func_74759_k("Palette") : null;
        ((INewBlockStateContainer)extendedBlockStorage.func_186049_g()).setTemporaryPalette(palette);
        NibbleArray add2 = storageNBT.func_150297_b("Add2", 7) ? new NibbleArray(storageNBT.func_74770_j("Add2")) : null;
        ((INewBlockStateContainer)extendedBlockStorage.func_186049_g()).setLegacyAdd2(add2);
    }

    @Inject(method={"writeChunkToNBT"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/chunk/BlockStateContainer;getDataForNBT([BLnet/minecraft/world/chunk/NibbleArray;)Lnet/minecraft/world/chunk/NibbleArray;", ordinal=0)})
    private void reid$writePaletteNBT(CallbackInfo ci, @Local ExtendedBlockStorage extendedBlockStorage, @Local(ordinal=1) NBTTagCompound storageNBT) {
        int[] palette = ((INewBlockStateContainer)extendedBlockStorage.func_186049_g()).getTemporaryPalette();
        if (palette != null) {
            storageNBT.func_74783_a("Palette", palette);
        }
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;hasKey(Ljava/lang/String;I)Z", ordinal=1)})
    private void reid$readBiomeArray(World world, NBTTagCompound nbt, CallbackInfoReturnable<Chunk> cir, @Local Chunk chunk) {
        INewChunk newChunk = (INewChunk)chunk;
        if (nbt.func_150297_b("Biomes", 11)) {
            newChunk.setIntBiomeArray(nbt.func_74759_k("Biomes"));
        } else {
            int[] intBiomeArray = new int[256];
            int index = 0;
            for (byte b : nbt.func_74770_j("Biomes")) {
                intBiomeArray[index++] = b & 0xFF;
            }
            newChunk.setIntBiomeArray(intBiomeArray);
        }
    }

    @Redirect(method={"writeChunkToNBT"}, slice=@Slice(id="nbtBiomes", from=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;setHasEntities(Z)V")), at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setByteArray(Ljava/lang/String;[B)V", ordinal=0, slice="nbtBiomes"))
    private void reid$writeBiomeArray(NBTTagCompound instance, String key, byte[] value, Chunk chunkIn) {
        if (!key.equals("Biomes")) {
            throw new AssertionError((Object)"jeid :: Sliced target setByteArray isn't \"Biomes\"");
        }
        instance.func_74783_a(key, ((INewChunk)chunkIn).getIntBiomeArray());
    }

    @Redirect(method={"writeChunkToNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getBiomeArray()[B", ordinal=0))
    private byte[] reid$defaultWriteBiomeArray(Chunk chunk) {
        return new byte[0];
    }
}

