/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import crafttweaker.IAction;
import java.lang.reflect.Field;
import youyihj.zenutils.api.reload.ActionReloadCallback;

public abstract class ReflectionAccessibleActionReloadCallback<T extends IAction>
extends ActionReloadCallback<T> {
    private static final Table<Class<?>, String, Field> FIELD_CACHE = HashBasedTable.create();

    public ReflectionAccessibleActionReloadCallback(T action) {
        super(action);
    }

    protected final <U> U getActionField(String fieldName) {
        try {
            return (U)this.findField(fieldName).get(this.action);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private Field findField(String fieldName) throws NoSuchFieldException {
        Class<?> actionClass = this.action.getClass();
        Field field = (Field)FIELD_CACHE.get(actionClass, (Object)fieldName);
        if (field == null) {
            for (Class<?> clazz = actionClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            if (field != null) {
                field.setAccessible(true);
                FIELD_CACHE.put(actionClass, (Object)fieldName, (Object)field);
            } else {
                throw new NoSuchFieldException(fieldName + " does not exist in " + actionClass.getSimpleName() + " or any of its superclasses.");
            }
        }
        return field;
    }
}

