/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.compat.vanilla;

import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.util.IngredientMap;
import java.util.regex.Pattern;
import stanhebben.zenscript.util.Pair;
import youyihj.zenrecipereloading.mixins.crafttweaker.IngredientTooltipsAccessor;
import youyihj.zenrecipereloading.util.PrivateActionReloadCallback;

public class TooltipCallbacks {
    public static String getActionName(String path) {
        return "crafttweaker.api.tooltip.IngredientTooltips$" + path;
    }

    public static class RemoveTooltipLineAction
    extends PrivateActionReloadCallback {
        public RemoveTooltipLineAction(IAction action) {
            super(action);
        }

        public void undo() {
            IngredientMap.IngredientMapEntry entry = new IngredientMap.IngredientMapEntry((IIngredient)this.getActionField("ingredient"), this.getActionField("line"));
            IngredientTooltipsAccessor.getRemovedTooltipsLine().unregister(entry);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class ClearTooltipAction
    extends PrivateActionReloadCallback {
        public ClearTooltipAction(IAction action) {
            super(action);
        }

        public void undo() {
            IngredientMap.IngredientMapEntry entry = new IngredientMap.IngredientMapEntry((IIngredient)this.getActionField("ingredient"), this.getActionField("leaveName"));
            IngredientTooltipsAccessor.getClearedTooltips().unregister(entry);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class AddAdvancedTooltipAction
    extends PrivateActionReloadCallback {
        public AddAdvancedTooltipAction(IAction action) {
            super(action);
        }

        public void undo() {
            boolean shift = (Boolean)this.getActionField("shift");
            IngredientMap.IngredientMapEntry entry = new IngredientMap.IngredientMapEntry((IIngredient)this.getActionField("ingredient"), (Object)new Pair(this.getActionField("function"), this.getActionField("showMessage")));
            (shift ? IngredientTooltipsAccessor.getShiftTooltipFunctions() : IngredientTooltipsAccessor.getTooltipFunctions()).unregister(entry);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class RemoveTooltipAction
    extends PrivateActionReloadCallback {
        public RemoveTooltipAction(IAction action) {
            super(action);
        }

        public void undo() {
            IngredientMap.IngredientMapEntry entry = new IngredientMap.IngredientMapEntry((IIngredient)this.getActionField("ingredient"), (Object)Pattern.compile((String)this.getActionField("regex")));
            IngredientTooltipsAccessor.getRemovedTooltips().unregister(entry);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class AddTooltipAction
    extends PrivateActionReloadCallback {
        public AddTooltipAction(IAction action) {
            super(action);
        }

        public void undo() {
            boolean shift = (Boolean)this.getActionField("shift");
            IngredientMap.IngredientMapEntry entry = new IngredientMap.IngredientMapEntry((IIngredient)this.getActionField("ingredient"), (Object)new Pair(this.getActionField("tooltip"), this.getActionField("showMessage")));
            (shift ? IngredientTooltipsAccessor.getShiftTooltips() : IngredientTooltipsAccessor.getTooltips()).unregister(entry);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }
}

