/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.compat.immersiveengineering;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import youyihj.zenrecipereloading.util.PrivateActionReloadCallback;

public class DieselCallbacks {
    public static String getActionName(String path) {
        return "blusunrize.immersiveengineering.common.util.compat.crafttweaker.DieselHelper$" + path;
    }

    public static class RemoveDrillFuel
    extends PrivateActionReloadCallback {
        public RemoveDrillFuel(IAction action) {
            super(action);
        }

        public void undo() {
            ILiquidStack fuel = (ILiquidStack)this.getActionField("fuel");
            DieselHandler.registerDrillFuel((Fluid)FluidRegistry.getFluid((String)fuel.getName()));
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class AddDrillFuel
    extends PrivateActionReloadCallback {
        public AddDrillFuel(IAction action) {
            super(action);
        }

        public void undo() {
            ILiquidStack fuel = (ILiquidStack)this.getActionField("fuel");
            DieselHandler.removeDrillFuel((Fluid)FluidRegistry.getFluid((String)fuel.getName()));
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class RemoveFuel
    extends PrivateActionReloadCallback {
        private int time;

        public RemoveFuel(IAction action) {
            super(action);
        }

        public void beforeApply(boolean reload) {
            ILiquidStack fuel = (ILiquidStack)this.getActionField("fuel");
            this.time = DieselHandler.getBurnTime((Fluid)FluidRegistry.getFluid((String)fuel.getName()));
        }

        public void undo() {
            if (this.time != 0) {
                ILiquidStack fuel = (ILiquidStack)this.getActionField("fuel");
                DieselHandler.registerFuel((Fluid)FluidRegistry.getFluid((String)fuel.getName()), (int)this.time);
            }
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class AddFuel
    extends PrivateActionReloadCallback {
        public AddFuel(IAction action) {
            super(action);
        }

        public void undo() {
            ILiquidStack fuel = (ILiquidStack)this.getActionField("fuel");
            DieselHandler.removeFuel((Fluid)FluidRegistry.getFluid((String)fuel.getName()));
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }
}

