/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.compat.gregtech;

import crafttweaker.IAction;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.ValidationResult;
import java.util.function.Consumer;
import youyihj.zenrecipereloading.mixins.gregtech.RecipeBuilderAccessor;
import youyihj.zenutils.api.reload.Reloadable;

@Reloadable
public class BuildRecipeAction<R extends RecipeBuilder<R>>
implements IAction {
    private final R recipeBuilder;
    private ValidationResult<Recipe> recipe;

    public BuildRecipeAction(RecipeBuilder<?> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
    }

    public void apply() {
        this.recipe = this.recipeBuilder.isCTRecipe().build();
        Consumer onBuildAction = ((RecipeBuilderAccessor)this.recipeBuilder).getOnBuildAction();
        if (onBuildAction != null) {
            onBuildAction.accept(this.recipeBuilder);
        }
        ((RecipeBuilderAccessor)this.recipeBuilder).getRecipeMap().addRecipe(this.recipe);
    }

    public String describe() {
        return "Adding a GregTech recipe: " + this.recipeBuilder;
    }

    public void undo() {
        if (this.recipe.getType() == EnumValidationResult.VALID) {
            ((RecipeBuilderAccessor)this.recipeBuilder).getRecipeMap().removeRecipe((Recipe)this.recipe.getResult());
        }
    }
}

