/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.compat.forestry;

import crafttweaker.IAction;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import youyihj.zenrecipereloading.util.PrivateActionReloadCallback;

public class CharcoalPileCallbacks {

    public static class Remove
    extends PrivateActionReloadCallback {
        private ICharcoalPileWall recipe;

        public Remove(IAction action) {
            super(action);
        }

        public void beforeApply(boolean reload) {
            IBlockState state = (IBlockState)this.getActionField("state");
            if (state == null) {
                Block block = (Block)this.getActionField("block");
                state = block.func_176223_P();
            }
            for (ICharcoalPileWall wall : Objects.requireNonNull(TreeManager.charcoalManager).getWalls()) {
                if (!wall.matches(state)) continue;
                this.recipe = wall;
                break;
            }
        }

        public void undo() {
            Objects.requireNonNull(TreeManager.charcoalManager).registerWall(this.recipe);
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }

    public static class Add
    extends PrivateActionReloadCallback {
        public Add(IAction action) {
            super(action);
        }

        public void undo() {
            Block block = (Block)this.getActionField("block");
            IBlockState state = (IBlockState)this.getActionField("state");
            if (block != null) {
                Objects.requireNonNull(TreeManager.charcoalManager).removeWall(block);
            }
            if (state != null) {
                Objects.requireNonNull(TreeManager.charcoalManager).removeWall(state);
            }
        }

        public boolean hasUndoMethod() {
            return true;
        }
    }
}

