/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenrecipereloading.compat.embers;

import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import teamroots.embers.compat.crafttweaker.Melter;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import youyihj.zenrecipereloading.mixins.embers.MelterAddAccessor;
import youyihj.zenrecipereloading.mixins.embers.MelterRemoveByInputAccessor;
import youyihj.zenrecipereloading.mixins.embers.MelterRemoveByOutputAccessor;
import youyihj.zenrecipereloading.util.MixinAccessibleActionReloadCallback;
import youyihj.zenutils.api.reload.ActionReloadCallback;

public class MelterCallbacks {

    public static class Add
    extends MixinAccessibleActionReloadCallback<Melter.Add, MelterAddAccessor> {
        public Add(Melter.Add action) {
            super(action);
        }

        public void undo() {
            RecipeRegistry.meltingRecipes.remove(((MelterAddAccessor)this.getActionAccessor()).getRecipe());
        }
    }

    public static class RemoveByOutput
    extends MixinAccessibleActionReloadCallback<Melter.RemoveByOutput, MelterRemoveByOutputAccessor> {
        private List<ItemMeltingRecipe> backup;

        public RemoveByOutput(Melter.RemoveByOutput action) {
            super(action);
        }

        public void beforeApply(boolean reload) {
            this.backup = RecipeRegistry.meltingRecipes.stream().filter(it -> ((MelterRemoveByOutputAccessor)this.getActionAccessor()).getOutput().isFluidStackIdentical(it.getFluid())).collect(Collectors.toList());
        }

        public void undo() {
            RecipeRegistry.meltingRecipes.addAll(this.backup);
        }
    }

    public static class RemoveByInput
    extends MixinAccessibleActionReloadCallback<Melter.RemoveByInput, MelterRemoveByInputAccessor> {
        private List<ItemMeltingRecipe> backup;

        public RemoveByInput(Melter.RemoveByInput action) {
            super(action);
        }

        public void beforeApply(boolean reload) {
            this.backup = RecipeRegistry.meltingRecipes.stream().filter(it -> it.input.apply(((MelterRemoveByInputAccessor)this.getActionAccessor()).getInput())).collect(Collectors.toList());
        }

        public void undo() {
            RecipeRegistry.meltingRecipes.addAll(this.backup);
        }
    }

    public static class RemoveAll
    extends ActionReloadCallback<Melter.RemoveAll> {
        private List<ItemMeltingRecipe> backup;

        public RemoveAll(Melter.RemoveAll action) {
            super((IAction)action);
        }

        public void beforeApply(boolean reload) {
            this.backup = new ArrayList<ItemMeltingRecipe>(RecipeRegistry.meltingRecipes);
        }

        public void undo() {
            RecipeRegistry.meltingRecipes.addAll(this.backup);
        }
    }
}

