/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.core;

import austeretony.rebind.client.keybinding.KeyBindingWrapper;
import austeretony.rebind.client.reference.ClientReference;
import austeretony.rebind.common.config.ConfigLoader;
import austeretony.rebind.common.config.EnumConfigSettings;
import austeretony.rebind.common.core.ReBindClassTransformer;
import austeretony.rebind.common.main.ReBindMain;
import austeretony.rebind.common.reference.CommonReference;
import com.google.common.base.Splitter;
import com.google.common.collect.LinkedHashMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Keyboard;

public class ReBindHooks {
    public static final Set<String> ID_OCCURENCES = new HashSet<String>();
    private static boolean isKnown;
    private static String modId;
    private static String modName;
    private static String keyBindingId;
    private static KeyBindingWrapper keyBindingProperty;
    private static int keyCount;

    public static void loadCustomLocalization(List<String> languageList, Map<String, String> properties) {
        ConfigLoader.loadCustomLocalization(languageList, properties);
    }

    public static void removeHiddenKeyBindings() {
        if (ClientReference.getGameSettings() != null) {
            ArrayList<KeyBinding> bindingsList = new ArrayList<KeyBinding>(Arrays.asList(ClientReference.getKeyBindings()));
            for (KeyBinding keyBinding : KeyBindingWrapper.PROPERTIES_BY_KEYBINDINGS.keySet()) {
                if (bindingsList.contains(keyBinding)) continue;
                bindingsList.add(keyBinding);
            }
            HashSet<String> occurrences = new HashSet<String>();
            Iterator iterator = bindingsList.iterator();
            while (iterator.hasNext()) {
                KeyBinding keyBinding = (KeyBinding)iterator.next();
                KeyBindingWrapper property = KeyBindingWrapper.get(keyBinding);
                if (property.isKeyBindingMerged()) {
                    iterator.remove();
                    continue;
                }
                if (!property.isEnabled()) {
                    keyBinding.func_151462_b(property.getKeyCode());
                    iterator.remove();
                    continue;
                }
                occurrences.add(keyBinding.func_151466_e());
            }
            KeyBinding.func_151467_c().retainAll(occurrences);
            ClientReference.getGameSettings().field_74324_K = bindingsList.toArray(new KeyBinding[bindingsList.size()]);
        }
    }

    public static void removeControlsSettings() {
        if (EnumConfigSettings.REWRITE_CONTROLS.isEnabled()) {
            List optionsLines;
            String optionsPath = CommonReference.getGameFolder() + "/options.txt";
            try (FileInputStream inputStream = new FileInputStream(new File(optionsPath));){
                optionsLines = IOUtils.readLines((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"));
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return;
            }
            HashSet options = new HashSet();
            Splitter splitter = Splitter.on((char)':');
            for (String option : optionsLines) {
                Iterator splitIterator = splitter.split((CharSequence)option).iterator();
                options.add(splitIterator.next());
                splitIterator.next();
            }
            if (!(options.contains("key_key.quit") || options.contains("key_key.hideHUD") || options.contains("key_key.debugScreen") || options.contains("key_key.switchShader"))) {
                Iterator iterator = optionsLines.iterator();
                while (iterator.hasNext()) {
                    String curLine = (String)iterator.next();
                    if (curLine.length() <= 4 || !curLine.substring(0, 4).equals("key_")) continue;
                    iterator.remove();
                }
                try (PrintStream printStream = new PrintStream(new File(optionsPath));){
                    for (String line : optionsLines) {
                        printStream.println(line);
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static KeyBinding[] sortKeyBindings() {
        if (KeyBindingWrapper.SORTED_KEYBINDINGS.isEmpty()) {
            KeyBinding keyBinding;
            ReBindHooks.removeHiddenKeyBindings();
            ArrayList<KeyBinding> bindingsList = new ArrayList<KeyBinding>(Arrays.asList(ClientReference.getKeyBindings()));
            Iterator<Map.Entry<String, KeyBindingWrapper>> propIterator = KeyBindingWrapper.PROPERTIES_BY_IDS.entrySet().iterator();
            while (propIterator.hasNext()) {
                KeyBindingWrapper prop = propIterator.next().getValue();
                if (prop.getKeyBinding() == null) {
                    propIterator.remove();
                    continue;
                }
                if (!prop.isKnown() || !prop.isEnabled() || !prop.isFullyLoaded() || prop.isKeyBindingMerged() || !bindingsList.contains(keyBinding = prop.getKeyBinding())) continue;
                KeyBindingWrapper.SORTED_KEYBINDINGS.add(prop.getKeyBinding());
            }
            LinkedHashMultimap propsByModnames = LinkedHashMultimap.create();
            TreeSet<String> sortedModNames = new TreeSet<String>();
            for (KeyBindingWrapper property : KeyBindingWrapper.UNKNOWN) {
                propsByModnames.put((Object)property.getModName(), (Object)property);
                sortedModNames.add(property.getModName());
            }
            for (String modName : sortedModNames) {
                for (KeyBindingWrapper property : propsByModnames.get((Object)modName)) {
                    keyBinding = property.getKeyBinding();
                    if (!bindingsList.contains(keyBinding)) continue;
                    KeyBindingWrapper.SORTED_KEYBINDINGS.add(property.getKeyBinding());
                }
            }
        }
        return KeyBindingWrapper.SORTED_KEYBINDINGS.toArray(new KeyBinding[KeyBindingWrapper.SORTED_KEYBINDINGS.size()]);
    }

    public static boolean isKeyDown(KeyBinding keyBinding) {
        KeyBindingWrapper property = KeyBindingWrapper.get(keyBinding);
        if (!property.isKeyBindingMerged()) {
            return keyBinding.field_74513_e && keyBinding.getKeyConflictContext().isActive() && keyBinding.getKeyModifier().isActive(keyBinding.getKeyConflictContext());
        }
        KeyBinding holder = property.getHolderKeyBinding();
        return holder.field_74513_e && holder.getKeyConflictContext().isActive() && holder.getKeyModifier().isActive(holder.getKeyConflictContext());
    }

    public static boolean isPressed(KeyBinding keyBinding) {
        KeyBindingWrapper property = KeyBindingWrapper.get(keyBinding);
        if (!property.isKeyBindingMerged()) {
            if (keyBinding.field_151474_i == 0) {
                return false;
            }
            --keyBinding.field_151474_i;
            return true;
        }
        return property.getHolderKeyBinding().field_151474_i != 0;
    }

    public static boolean isActiveAndMatches(KeyBinding keyBinding, int keyCode) {
        if (!KeyBindingWrapper.get(keyBinding).isKeyBindingMerged()) {
            return keyCode != 0 && keyCode == keyBinding.func_151463_i() && keyBinding.getKeyConflictContext().isActive() && keyBinding.getKeyModifier().isActive(keyBinding.getKeyConflictContext());
        }
        return false;
    }

    public static int getQuitKeyCode() {
        return ReBindMain.keyBindingQuit.func_151463_i();
    }

    public static boolean isQuitKeyPressed(int key) {
        return ReBindMain.keyBindingQuit.isActiveAndMatches(key);
    }

    public static boolean isHideHUDKeyPressed(int key) {
        return ReBindMain.keyBindingHideHUD.isActiveAndMatches(key);
    }

    public static int getDebugScreenKeyCode() {
        return ReBindMain.keyBindingDebugScreen.isActiveAndMatches(ReBindMain.keyBindingDebugScreen.func_151463_i()) ? ReBindMain.keyBindingDebugScreen.func_151463_i() : 0;
    }

    public static int getSwitchShaderKeyCode() {
        return ReBindMain.keyBindingSwitchShader.func_151468_f() ? ReBindMain.keyBindingSwitchShader.func_151463_i() : 0;
    }

    public static boolean isNarratorKeyPressed(int key) {
        return ReBindMain.keyBindingNarrator.isActiveAndMatches(key);
    }

    public static boolean isMineMenuKeyPressed(KeyBinding keyBinding) {
        return keyBinding.isActiveAndMatches(Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey());
    }

    public static String getKeyBindingName(String keyName) {
        if (Loader.instance().activeModContainer() != null) {
            modId = Loader.instance().activeModContainer().getModId();
            modName = Loader.instance().activeModContainer().getName();
        } else if (keyCount < 33) {
            modId = "mc";
            modName = "Minecraft";
        } else {
            modId = "optifine";
            modName = "Optifine";
        }
        modId = modId.toLowerCase();
        keyBindingId = modId + "_" + keyName.toLowerCase();
        keyBindingId = keyBindingId.replaceAll("[()?:!.,;{} |]+", "_").replace("_key", "").replace("_" + modId, "");
        while (ID_OCCURENCES.contains(keyBindingId)) {
            keyBindingId = keyBindingId + "_";
        }
        isKnown = KeyBindingWrapper.PROPERTIES_BY_IDS.containsKey(keyBindingId);
        ReBindClassTransformer.CORE_LOGGER.info("Keybinding id: " + keyBindingId + ", known: " + isKnown);
        if (isKnown && !(keyBindingProperty = KeyBindingWrapper.get(keyBindingId)).getName().isEmpty()) {
            keyName = keyBindingProperty.getName();
        }
        return keyName;
    }

    public static KeyModifier getKeyBindingKeyModifier(KeyModifier keyModifier) {
        if (isKnown) {
            keyModifier = KeyModifier.valueFromString((String)keyBindingProperty.getKeyModifier());
        }
        return keyModifier;
    }

    public static int getKeyBindingKeyCode(int keyCode) {
        if (isKnown) {
            keyCode = keyBindingProperty.getKeyCode();
        }
        return keyCode;
    }

    public static String getKeyBindingCategory(String category) {
        String cat;
        category = isKnown ? ((cat = keyBindingProperty.getCategory()).equals("mc.gameplay") || cat.equals("mc.movement") || cat.equals("mc.inventory") || cat.equals("mc.misc") || cat.equals("mc.creative") || cat.equals("mc.multiplayer") ? "key.categories." + cat.substring(3) : keyBindingProperty.getCategory()) : modName;
        return category;
    }

    public static void wrapKeybinding(KeyBinding keyBinding) {
        ++keyCount;
        if (!isKnown) {
            keyBindingProperty = new KeyBindingWrapper(keyBindingId, "", "", modName, keyBinding.func_151469_h(), keyBinding.getKeyModifierDefault() == KeyModifier.NONE ? "" : keyBinding.getKeyModifierDefault().toString(), true, false);
        }
        keyBindingProperty.bindKeyBinding(keyBinding);
        keyBindingProperty.setModId(modId);
        keyBindingProperty.setModName(modName);
        ID_OCCURENCES.add(keyBindingId);
    }

    public static boolean isDoubleTapForwardSprintAllowed() {
        return EnumConfigSettings.PLAYER_SPRINT.isEnabled() && EnumConfigSettings.DOUBLE_TAP_FORWARD_SPRINT.isEnabled();
    }

    public static boolean isPlayerSprintAllowed() {
        return !ClientReference.getClientPlayer().func_184218_aH() && EnumConfigSettings.PLAYER_SPRINT.isEnabled() || ClientReference.getClientPlayer().func_184218_aH() && EnumConfigSettings.MOUNT_SPRINT.isEnabled();
    }

    public static int isHotbarScrollingAllowed(int direction) {
        return EnumConfigSettings.HOTBAR_SCROLLING.isEnabled() ? direction : 0;
    }
}

