/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.core;

import austeretony.rebind.common.config.EnumConfigSettings;
import austeretony.rebind.common.core.ReBindCorePlugin;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public enum EnumInputClasses {
    FORGE_FML_CLIENT_HANDLER("Forge", "FMLClientHandler", 0, 3),
    MC_LOCALE("Minecraft", "Locale", 0, 3),
    MC_KEY_BINDING("Minecraft", "KeyBinding", 0, 3),
    MC_GUI_KEY_BINDING_LIST("Minecraft", "GuiKeyBindingList", 0, 3),
    MC_MINECRAFT("Minecraft", "Minecraft", 0, 3),
    MC_GUI_SCREEN("Minecraft", "GuiScreen", 0, 3),
    MC_GUI_CONTAINER("Minecraft", "GuiContainer", 0, 3),
    MC_ENTITY_PLAYER_SP("Minecraft", "EntityPlayerSP", 0, 3),
    CONTROLING_GUI_NEW_KEY_BINDING_LIST("Controling", "GuiNewKeyBindingList", 0, 3),
    MM_KEYBOARD_HANDLER("MineMenu", "KeyboardHandler", 0, 3);

    private static final String HOOKS_CLASS = "austeretony/rebind/common/core/ReBindHooks";
    public final String domain;
    public final String clazz;
    public final int readerFlags;
    public final int writerFlags;

    private EnumInputClasses(String domain, String clazz, int readerFlags, int writerFlags) {
        this.domain = domain;
        this.clazz = clazz;
        this.readerFlags = readerFlags;
        this.writerFlags = writerFlags;
    }

    public boolean patch(ClassNode classNode) {
        switch (this) {
            case FORGE_FML_CLIENT_HANDLER: {
                return this.patchForgeFMLClientHandler(classNode);
            }
            case MC_LOCALE: {
                return this.pathcMCLocale(classNode);
            }
            case MC_KEY_BINDING: {
                return this.patchMCKeyBinding(classNode);
            }
            case MC_GUI_KEY_BINDING_LIST: {
                return this.patchMCGuiKeyBindingList(classNode);
            }
            case MC_MINECRAFT: {
                return this.patchMCMinecraft(classNode);
            }
            case MC_GUI_SCREEN: {
                return this.patchMCGuiScreen(classNode);
            }
            case MC_GUI_CONTAINER: {
                return this.patchMCGuiContainer(classNode);
            }
            case MC_ENTITY_PLAYER_SP: {
                return this.patchMCEntityPlayerSP(classNode);
            }
            case CONTROLING_GUI_NEW_KEY_BINDING_LIST: {
                return this.patchControlingGuiKeyBindingList(classNode);
            }
            case MM_KEYBOARD_HANDLER: {
                return EnumConfigSettings.FIX_MM_KEYBINDING.isEnabled() ? this.patchMMKeyboardHanndler(classNode) : false;
            }
        }
        return false;
    }

    private boolean patchForgeFMLClientHandler(ClassNode classNode) {
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("finishMinecraftLoading") || !methodNode.desc.equals("()V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 3) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "removeHiddenKeyBindings", "()V", false));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "removeControlsSettings", "()V", false));
                methodNode.instructions.insert(currentInsn.getNext(), nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCLocale(ClassNode classNode) {
        String propertiesFieldName = ReBindCorePlugin.isObfuscated() ? "a" : "properties";
        String loadLocaleDataFilesMethodName = ReBindCorePlugin.isObfuscated() ? "a" : "loadLocaleDataFiles";
        String localeClassName = ReBindCorePlugin.isObfuscated() ? "cfb" : "net/minecraft/client/resources/Locale";
        String iResourceManagerClassName = ReBindCorePlugin.isObfuscated() ? "cep" : "net/minecraft/client/resources/IResourceManager";
        String listClassName = "java/util/List";
        String mapClassName = "java/util/Map";
        boolean isSuccessful = false;
        int invokespecialCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(loadLocaleDataFilesMethodName) || !methodNode.desc.equals("(L" + iResourceManagerClassName + ";L" + listClassName + ";)V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 183 || ++invokespecialCount != 3) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new FieldInsnNode(180, localeClassName, propertiesFieldName, "L" + mapClassName + ";"));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "loadCustomLocalization", "(L" + listClassName + ";L" + mapClassName + ";)V", false));
                methodNode.instructions.insertBefore(currentInsn.getPrevious(), nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean patchMCKeyBinding(ClassNode classNode) {
        String stringClassName = "java/lang/String";
        String isKeyDownMethodName = ReBindCorePlugin.isObfuscated() ? "e" : "isKeyDown";
        String isPressedMethodName = ReBindCorePlugin.isObfuscated() ? "g" : "isPressed";
        String isActiveAndMatchesMethodName = "isActiveAndMatches";
        String keyBindingClassName = ReBindCorePlugin.isObfuscated() ? "bhy" : "net/minecraft/client/settings/KeyBinding";
        String iKeyConflictContextClassName = "net/minecraftforge/client/settings/IKeyConflictContext";
        String keyConflictContextClassName = "net/minecraftforge/client/settings/KeyConflictContext";
        String keyModifierClassName = "net/minecraftforge/client/settings/KeyModifier";
        boolean descChanged = false;
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            InsnList nodesList;
            if (methodNode.name.equals("<init>") && methodNode.desc.equals("(L" + stringClassName + ";IL" + stringClassName + ";)V")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (currentInsn.getOpcode() != 25) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nodesList.add((AbstractInsnNode)new FieldInsnNode(178, keyConflictContextClassName, "UNIVERSAL", "L" + keyConflictContextClassName + ";"));
                    nodesList.add((AbstractInsnNode)new FieldInsnNode(178, keyModifierClassName, "NONE", "L" + keyModifierClassName + ";"));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(183, keyBindingClassName, "<init>", "(L" + stringClassName + ";L" + iKeyConflictContextClassName + ";L" + keyModifierClassName + ";IL" + stringClassName + ";)V", false));
                    nodesList.add((AbstractInsnNode)new InsnNode(177));
                    methodNode.instructions.insertBefore(currentInsn, nodesList);
                    break;
                }
            }
            if (methodNode.name.equals(isKeyDownMethodName) && methodNode.desc.equals("()Z")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (currentInsn.getOpcode() != 25) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isKeyDown", "(L" + keyBindingClassName + ";)Z", false));
                    nodesList.add((AbstractInsnNode)new InsnNode(172));
                    methodNode.instructions.insertBefore(currentInsn, nodesList);
                    break;
                }
            }
            if (methodNode.name.equals(isPressedMethodName) && methodNode.desc.equals("()Z")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (currentInsn.getOpcode() != 25) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isPressed", "(L" + keyBindingClassName + ";)Z", false));
                    nodesList.add((AbstractInsnNode)new InsnNode(172));
                    methodNode.instructions.insertBefore(currentInsn, nodesList);
                    break;
                }
            }
            if (methodNode.name.equals("<init>") && methodNode.desc.equals("(L" + stringClassName + ";L" + iKeyConflictContextClassName + ";L" + keyModifierClassName + ";IL" + stringClassName + ";)V")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (!descChanged && currentInsn.getOpcode() == 183) {
                        nodesList = new InsnList();
                        nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getKeyBindingName", "(L" + stringClassName + ";)L" + stringClassName + ";", false));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(58, 1));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                        nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getKeyBindingKeyModifier", "(L" + keyModifierClassName + ";)L" + keyModifierClassName + ";", false));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(58, 3));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(21, 4));
                        nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getKeyBindingKeyCode", "(I)I", false));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(54, 4));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(25, 5));
                        nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getKeyBindingCategory", "(L" + stringClassName + ";)L" + stringClassName + ";", false));
                        nodesList.add((AbstractInsnNode)new VarInsnNode(58, 5));
                        methodNode.instructions.insert(currentInsn, nodesList);
                        descChanged = true;
                    }
                    if (currentInsn.getOpcode() != 177) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "wrapKeybinding", "(L" + keyBindingClassName + ";)V", false));
                    methodNode.instructions.insertBefore(currentInsn, nodesList);
                    break;
                }
            }
            if (!methodNode.name.equals(isActiveAndMatchesMethodName) || !methodNode.desc.equals("(I)Z")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 25) continue;
                nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 1));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isActiveAndMatches", "(L" + keyBindingClassName + ";I)Z", false));
                nodesList.add((AbstractInsnNode)new InsnNode(172));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                continue block0;
            }
        }
        return isSuccessful;
    }

    private boolean patchMCGuiKeyBindingList(ClassNode classNode) {
        String keyBindingClassName = ReBindCorePlugin.isObfuscated() ? "bhy" : "net/minecraft/client/settings/KeyBinding";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("<init>")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                InsnList nodesList;
                if (currentInsn.getOpcode() == 58) {
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "sortKeyBindings", "()[L" + keyBindingClassName + ";", false));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(58, 3));
                    methodNode.instructions.insert(currentInsn, nodesList);
                    continue;
                }
                if (currentInsn.getOpcode() != 1) continue;
                nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "sortKeyBindings", "()[L" + keyBindingClassName + ";", false));
                nodesList.add((AbstractInsnNode)new VarInsnNode(58, 3));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean patchMCMinecraft(ClassNode classNode) {
        String runTickKeyboardMethodName = ReBindCorePlugin.isObfuscated() ? "aD" : "runTickKeyboard";
        String runTickMouseMethodName = ReBindCorePlugin.isObfuscated() ? "aG" : "runTickMouse";
        String dispatchKeypressesMethodName = ReBindCorePlugin.isObfuscated() ? "W" : "dispatchKeypresses";
        boolean isSuccessful = false;
        int bipushCount = 0;
        int iconstCount = 0;
        int iloadCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            InsnList nodesList;
            AbstractInsnNode currentInsn2;
            ListIterator insnIterator;
            if (methodNode.name.equals(runTickKeyboardMethodName) && methodNode.desc.equals("()V")) {
                insnIterator = methodNode.instructions.iterator();
                while (insnIterator.hasNext()) {
                    currentInsn2 = (AbstractInsnNode)insnIterator.next();
                    if (currentInsn2.getOpcode() == 16) {
                        if (++bipushCount == 2 || bipushCount == 4 || bipushCount == 6 || bipushCount == 10) {
                            methodNode.instructions.insertBefore(currentInsn2, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getDebugScreenKeyCode", "()I", false));
                            insnIterator.remove();
                            if (bipushCount == 10) break;
                        }
                        if (bipushCount == 5) {
                            methodNode.instructions.insertBefore(currentInsn2, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getSwitchShaderKeyCode", "()I", false));
                            insnIterator.remove();
                        }
                        if (bipushCount == 7) {
                            methodNode.instructions.insertBefore(currentInsn2, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isHideHUDKeyPressed", "(I)Z", false));
                            ((JumpInsnNode)currentInsn2.getNext()).setOpcode(153);
                            insnIterator.remove();
                        }
                    }
                    if (currentInsn2.getOpcode() != 4 || ++iconstCount != 2) continue;
                    methodNode.instructions.insertBefore(currentInsn2, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isQuitKeyPressed", "(I)Z", false));
                    ((JumpInsnNode)currentInsn2.getNext()).setOpcode(153);
                    insnIterator.remove();
                }
            }
            if (methodNode.name.equals(runTickMouseMethodName) && methodNode.desc.equals("()V")) {
                for (AbstractInsnNode currentInsn2 : methodNode.instructions) {
                    if (currentInsn2.getOpcode() != 21 || ++iloadCount != 8) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isHotbarScrollingAllowed", "(I)I", false));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(54, 4));
                    methodNode.instructions.insertBefore(currentInsn2, nodesList);
                    break;
                }
            }
            if (!methodNode.name.equals(dispatchKeypressesMethodName) || !methodNode.desc.equals("()V")) continue;
            insnIterator = methodNode.instructions.iterator();
            while (insnIterator.hasNext()) {
                currentInsn2 = (AbstractInsnNode)insnIterator.next();
                if (currentInsn2.getOpcode() != 16) continue;
                nodesList = new InsnList();
                methodNode.instructions.insertBefore(currentInsn2, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isNarratorKeyPressed", "(I)Z", false));
                methodNode.instructions.remove(currentInsn2.getNext().getNext());
                methodNode.instructions.remove(currentInsn2.getNext());
                insnIterator.remove();
                isSuccessful = true;
                break block0;
            }
            break block0;
        }
        return isSuccessful;
    }

    private boolean patchMCGuiScreen(ClassNode classNode) {
        String keyTypedMethodName = ReBindCorePlugin.isObfuscated() ? "a" : "keyTyped";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(keyTypedMethodName) || !methodNode.desc.equals("(CI)V")) continue;
            ListIterator insnIterator = methodNode.instructions.iterator();
            while (insnIterator.hasNext()) {
                AbstractInsnNode currentInsn = (AbstractInsnNode)insnIterator.next();
                if (currentInsn.getOpcode() != 4) continue;
                methodNode.instructions.insertBefore(currentInsn, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getQuitKeyCode", "()I", false));
                insnIterator.remove();
                isSuccessful = true;
                break block0;
            }
            break block0;
        }
        return isSuccessful;
    }

    private boolean patchMCGuiContainer(ClassNode classNode) {
        return this.patchMCGuiScreen(classNode);
    }

    private boolean patchMCEntityPlayerSP(ClassNode classNode) {
        String targetMethodName = ReBindCorePlugin.isObfuscated() ? "n" : "onLivingUpdate";
        boolean isSuccessful = false;
        int iconstCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(targetMethodName) || !methodNode.desc.equals("()V")) continue;
            ListIterator insnIterator = methodNode.instructions.iterator();
            while (insnIterator.hasNext()) {
                AbstractInsnNode currentInsn = (AbstractInsnNode)insnIterator.next();
                if (currentInsn.getOpcode() != 4) continue;
                if (++iconstCount == 9) {
                    methodNode.instructions.insert(currentInsn.getPrevious(), (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isDoubleTapForwardSprintAllowed", "()Z", false));
                    insnIterator.remove();
                }
                if (iconstCount != 10) continue;
                methodNode.instructions.insert(currentInsn.getPrevious(), (AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isPlayerSprintAllowed", "()Z", false));
                insnIterator.remove();
                isSuccessful = true;
                break block0;
            }
            break block0;
        }
        return isSuccessful;
    }

    private boolean patchControlingGuiKeyBindingList(ClassNode classNode) {
        return this.patchMCGuiKeyBindingList(classNode);
    }

    private boolean patchMMKeyboardHanndler(ClassNode classNode) {
        String wheelFieldName = "WHEEL";
        String onClientTickMethodName = "onClientTick";
        String keyboardHandlerClassname = "dmillerw/menu/handler/KeyboardHandler";
        String keyBindingClassName = "net/minecraft/client/settings/KeyBinding";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(onClientTickMethodName)) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 159) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new FieldInsnNode(178, keyboardHandlerClassname, wheelFieldName, "L" + keyBindingClassName + ";"));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isMineMenuKeyPressed", "(L" + keyBindingClassName + ";)Z", false));
                nodesList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)currentInsn).label));
                methodNode.instructions.insertBefore(currentInsn.getPrevious().getPrevious().getPrevious(), nodesList);
                methodNode.instructions.remove(currentInsn.getPrevious().getPrevious().getPrevious());
                methodNode.instructions.remove(currentInsn.getPrevious().getPrevious());
                methodNode.instructions.remove(currentInsn.getPrevious());
                methodNode.instructions.remove(currentInsn);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }
}

