/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util.world;

import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.config.DimensionTypeEntry;
import fi.dy.masa.justenoughdimensions.config.StructurePlacement;
import fi.dy.masa.justenoughdimensions.event.DataTracker;
import fi.dy.masa.justenoughdimensions.network.MessageSyncWorldProperties;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.util.SpawnPointSearch;
import fi.dy.masa.justenoughdimensions.util.world.Schematic;
import fi.dy.masa.justenoughdimensions.util.world.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import fi.dy.masa.justenoughdimensions.world.WorldProviderHellJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;

public class WorldUtils {
    private static final String JED_RESPAWN_DIM_TAG = "justenoughdimensions:respawndimension";
    private static Field field_World_provider = null;
    private static Field field_WorldProvider_biomeProvider = null;
    private static Field field_ChunkProviderServer_chunkGenerator = null;

    public static BlockPos getWorldSpawn(WorldServer world) {
        BlockPos spawn = world.func_180504_m();
        if (spawn == null) {
            spawn = world.func_175694_M();
        }
        return spawn;
    }

    public static int getLoadedChunkCount(WorldServer world) {
        return world.func_72863_F().func_73152_e();
    }

    public static int unloadEmptyDimensions(boolean tryUnloadChunks) {
        int count = 0;
        Integer[] dims = DimensionManager.getIDs();
        JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload empty dimensions, tryUnloadChunks = {}", tryUnloadChunks);
        Integer[] integerArray = dims;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload dimension {}", dim);
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            ChunkProviderServer chunkProviderServer = world.func_72863_F();
            int loadedCountBefore = chunkProviderServer.func_73152_e();
            if (tryUnloadChunks && loadedCountBefore > 0) {
                JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload chunks for dimension {}, currently loaded chunks: {}", dim, loadedCountBefore);
                boolean disable = world.field_73058_d;
                world.field_73058_d = false;
                try {
                    world.func_73044_a(true, (IProgressUpdate)null);
                }
                catch (MinecraftException e) {
                    JustEnoughDimensions.logger.warn("WorldUtils.unloadEmptyDimensions(): Exception while trying to save chunks for dimension {}", (Object)dim, (Object)e);
                }
                world.field_73058_d = disable;
                chunkProviderServer.func_73156_b();
                int loadedCountAfter = chunkProviderServer.func_73152_e();
                JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Unloaded {} chunks in dimension {}", loadedCountBefore - loadedCountAfter, dim);
                if (loadedCountAfter != 0) continue;
                JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Likely unloaded dimension {}", dim);
                ++count;
                continue;
            }
            if (chunkProviderServer.func_73152_e() != 0 || world.field_73011_w.func_186058_p().shouldLoadSpawn() || ForgeChunkManager.getPersistentChunksFor((World)world).size() != 0) continue;
            JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Unloading dimension {}", dim);
            DimensionManager.unloadWorld((int)world.field_73011_w.getDimension());
            ++count;
        }
        return count;
    }

    public static boolean removeTemporaryWorldIfApplicable(World world) {
        int dimension = world.field_73011_w.getDimension();
        File worldDir = WorldFileUtils.getWorldDirectory(world);
        return WorldUtils.removeTemporaryWorldIfApplicable(dimension, world, worldDir, false);
    }

    public static boolean removeTemporaryWorldIfApplicable(int dimension, @Nullable World world, File worldDir, boolean isServerStop) {
        File jedDataDir;
        File markerFile;
        DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(dimension);
        if (entry != null && entry.isTemporaryDimension() && (dimension != 0 || isServerStop) && worldDir != null && worldDir.exists() && DataTracker.getInstance().getPlayerCountInDimension(dimension) == 0 && (markerFile = WorldFileUtils.getTemporaryDimensionMarkerFile(jedDataDir = WorldFileUtils.getWorldJEDDataDirectory(worldDir))).exists()) {
            if (dimension == 0) {
                JustEnoughDimensions.logInfo("Trying to remove a temporary world '{}'", worldDir.getAbsolutePath());
            } else {
                JustEnoughDimensions.logInfo("Trying to remove a temporary dimension (DIM {}) from '{}'", dimension, worldDir.getAbsolutePath());
            }
            try {
                if (world != null && world instanceof WorldServer) {
                    ((WorldServer)world).func_73041_k();
                }
                FileUtils.deleteDirectory((File)worldDir);
                return true;
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Exception while trying to remove a temporary dimension {}", (Object)dimension, (Object)e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryDeleteDimension(int dimension, ICommandSender sender) {
        WorldServer world;
        if (dimension == 0) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Can't delete dimension 0, it would delete the entire save");
            return false;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldServer = world = server != null ? server.func_71218_a(dimension) : null;
        if (world == null) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Could not load dimension {} (to get the directory)", (Object)dimension);
            return false;
        }
        if (world.field_73010_i.size() > 0) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: There are currently players in dimension {}, can't delete it", (Object)dimension);
            return false;
        }
        File dir = WorldFileUtils.getWorldDirectory((World)world);
        if (!dir.exists() || !dir.isDirectory()) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Failed to get the directory for dimension {}", (Object)dimension);
            return false;
        }
        if (!(world instanceof WorldServer)) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Not a server world?!");
            return false;
        }
        WorldServer worldServer2 = world;
        try {
            worldServer2.func_72863_F().func_73240_a();
            worldServer2.func_73044_a(true, null);
            worldServer2.func_73041_k();
            DimensionManager.setWorld((int)dimension, null, (MinecraftServer)worldServer2.func_73046_m());
            FileUtils.deleteDirectory((File)dir);
            CommandJED.runBroadcastCommand(sender, "delete-dimension", dimension);
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Successfully deleted dimension {}", (Object)dimension);
            return true;
        }
        catch (MinecraftException e) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Exception while trying to unload dimension {}", (Object)dimension, (Object)e);
            return false;
        }
        catch (IOException e) {
            JustEnoughDimensions.logger.warn("WorldUtils.tryDeleteDimension: Exception while trying to delete the directory of dimension {}", (Object)dimension, (Object)e);
            return false;
        }
    }

    public static void syncWorldProviderProperties(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            JustEnoughDimensions.logInfo("WorldUtils.syncWorldProviderProperties: Syncing WorldProvider properties of dimension {} to player '{}'", player.func_130014_f_().field_73011_w.getDimension(), player.func_70005_c_());
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncWorldProperties(player.func_130014_f_()), (EntityPlayerMP)player);
        }
    }

    public static void overrideWorldProviderIfApplicable(World world) {
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(world);
        if (props != null && props.overrideWorldProvider()) {
            String newClassName = props.getWorldProviderOverrideClassName();
            Class<? extends WorldProvider> newProviderClass = DimensionTypeEntry.getProviderClass(newClassName);
            if (newProviderClass != null && newProviderClass != world.field_73011_w.getClass()) {
                int dim = world.field_73011_w.getDimension();
                String oldName = world.field_73011_w.getClass().getName();
                JustEnoughDimensions.logInfo("WorldUtils.overrideWorldProvider: Trying to override the WorldProvider of type '{}' in dimension {} with '{}'", oldName, dim, newClassName);
                try {
                    Constructor<? extends WorldProvider> constructor = newProviderClass.getConstructor(new Class[0]);
                    WorldProvider newProvider = constructor.newInstance(new Object[0]);
                    try {
                        field_World_provider.set(world, newProvider);
                        world.field_73011_w.func_76558_a(world);
                        world.field_73011_w.setDimension(dim);
                        JustEnoughDimensions.logInfo("WorldUtils.overrideWorldProvider: Overrode the WorldProvider in dimension {} with '{}'", dim, newClassName);
                        WorldUtils.reCreateChunkGenerator(world, dim == 0);
                    }
                    catch (Exception e) {
                        JustEnoughDimensions.logger.error("WorldUtils.overrideWorldProvider: Failed to override the WorldProvider of dimension {}", (Object)dim);
                    }
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JustEnoughDimensions.logger.warn("WorldUtils.overrideWorldProvider: Failed to create a WorldProvider from name '{}', or it was already that type", (Object)newClassName);
        }
    }

    public static void overrideBiomeProvider(World world) {
        if (!(world.field_73011_w instanceof WorldProviderSurfaceJED)) {
            int dimension = world.field_73011_w.getDimension();
            DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(dimension);
            if (entry != null) {
                BiomeProvider biomeProvider = null;
                if (entry.getBiome() != null) {
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(entry.getBiome()));
                    if (!(biome == null || world.field_73011_w.func_177499_m() instanceof BiomeProviderSingle && world.field_73011_w.func_177499_m().func_180631_a(BlockPos.field_177992_a) == biome)) {
                        biomeProvider = new BiomeProviderSingle(biome);
                        JustEnoughDimensions.logInfo("WorldUtils.overrideBiomeProvider: Overriding the BiomeProvider of dimension {} with '{}' using the biome '{}'", dimension, biomeProvider.getClass().getName(), entry.getBiome());
                    }
                } else if (entry.getBiomeProvider() != null) {
                    JustEnoughDimensions.logInfo("WorldUtils.overrideBiomeProvider: Trying to create a BiomeProvider for dimension {} from the class name '{}'", dimension, entry.getBiomeProvider());
                    biomeProvider = WorldUtils.createBiomeProviderForName(entry.getBiomeProvider(), world);
                } else if (entry.shouldUseNormalBiomes() && world.field_73011_w.func_177499_m() instanceof BiomeProviderSingle) {
                    biomeProvider = new BiomeProvider(world.func_72912_H());
                    JustEnoughDimensions.logInfo("WorldUtils.overrideBiomeProvider: Overriding the BiomeProvider of dimension {} with '{}'", dimension, biomeProvider.getClass().getName());
                }
                if (biomeProvider != null) {
                    try {
                        field_WorldProvider_biomeProvider.set(world.field_73011_w, biomeProvider);
                    }
                    catch (Exception e) {
                        JustEnoughDimensions.logger.error("Failed to override the BiomeProvider of dimension {}", (Object)dimension);
                    }
                }
            }
        }
    }

    @Nullable
    public static BiomeProvider createBiomeProviderForName(String name, World world) {
        try {
            Class<?> clazz = Class.forName(name);
            BiomeProvider provider = (BiomeProvider)clazz.getConstructor(WorldInfo.class).newInstance(world.func_72912_H());
            try {
                Method method = clazz.getDeclaredMethod("init", World.class);
                method.invoke((Object)provider, world);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return provider;
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("WorldUtils.createBiomeProviderForName(): Failed to create a BiomeProvider from class name '{}' ({})", (Object)name, (Object)e.getClass().getName());
            return null;
        }
    }

    public static void reCreateChunkGenerator(World world, boolean generatorChangedForOverworld) {
        if (world instanceof WorldServer && world.func_72863_F() instanceof ChunkProviderServer) {
            WorldInfo infoOverworld;
            int dimension = world.field_73011_w.getDimension();
            WorldInfo info = world.func_72912_H();
            WorldServer overworld = DimensionManager.getWorld((int)0);
            if (dimension == 0 && !generatorChangedForOverworld) {
                JustEnoughDimensions.logInfo("No need to re-create the ChunkProvider in dimension {}", dimension);
                return;
            }
            if (dimension != 0 && overworld != null && (infoOverworld = overworld.func_72912_H()).func_76067_t() == info.func_76067_t() && infoOverworld.func_76089_r() == info.func_76089_r() && infoOverworld.func_82571_y().equals(info.func_82571_y()) && infoOverworld.func_76063_b() == info.func_76063_b()) {
                JustEnoughDimensions.logInfo("No need to re-create the ChunkProvider in dimension {}", dimension);
                return;
            }
            world.field_73011_w.func_76558_a(world);
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
            IChunkGenerator newChunkGenerator = world.field_73011_w.func_186060_c();
            if (newChunkGenerator == null) {
                JustEnoughDimensions.logger.warn("Failed to re-create the ChunkProvider for dimension {}", (Object)dimension);
                return;
            }
            try {
                field_ChunkProviderServer_chunkGenerator.set(chunkProviderServer, newChunkGenerator);
                JustEnoughDimensions.logInfo("WorldUtils.reCreateChunkProvider: Re-created/overwrote the ChunkProvider (of type '{}') in dimension {} with '{}'", chunkProviderServer.field_186029_c.getClass().getName(), dimension, newChunkGenerator.getClass().getName());
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to re-create the ChunkProvider for dimension {} with {}", (Object)dimension, (Object)newChunkGenerator.getClass().getName(), (Object)e);
            }
        }
    }

    public static void centerWorldBorderIfApplicable(World world) {
        int dimension = world.field_73011_w.getDimension();
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(dimension);
        WorldBorder border = world.func_175723_af();
        BlockPos spawn = world.func_175694_M();
        if (props != null && props.shouldWorldBorderBeCenteredOnSpawn() && ((double)spawn.func_177958_n() != border.func_177731_f() || (double)spawn.func_177952_p() != border.func_177721_g())) {
            border.func_177739_c((double)spawn.func_177958_n(), (double)spawn.func_177952_p());
            JustEnoughDimensions.logInfo("WorldUtils.centerWorldBorderIfApplicable: Moved the WorldBorder of dimension {} to the spawn point @ {}", dimension, spawn);
        }
    }

    public static void findAndSetWorldSpawnIfApplicable(World world) {
        if (!WorldFileUtils.jedLevelFileExists(world)) {
            WorldUtils.findAndSetWorldSpawn(world);
        }
    }

    private static void findAndSetWorldSpawn(World world) {
        int dimension = world.field_73011_w.getDimension();
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(dimension);
        SpawnPointSearch searchType = props != null ? props.getSpawnPointSearchType() : null;
        NBTTagCompound nbt = WorldInfoUtils.getWorldInfoTag(world, dimension, false, false);
        BlockPos newSpawn = null;
        if (nbt.func_74764_b("SpawnX") && nbt.func_74764_b("SpawnZ")) {
            if (nbt.func_74764_b("SpawnY")) {
                newSpawn = new BlockPos(nbt.func_74762_e("SpawnX"), nbt.func_74762_e("SpawnY"), nbt.func_74762_e("SpawnZ"));
                JustEnoughDimensions.logInfo("WorldUtils.findAndSetWorldSpawn: An exact spawn point {} defined in the dimension config for dimension {}, skipping the search", newSpawn, dimension);
                WorldUtils.generateFallbackSpawnBlockIfEnabled(world, newSpawn);
            } else {
                newSpawn = new BlockPos(nbt.func_74762_e("SpawnX"), 72, nbt.func_74762_e("SpawnZ"));
                JustEnoughDimensions.logInfo("WorldUtils.findAndSetWorldSpawn: A spawn point XZ-location 'x = {}, z = {}' defined in the dimension config for dimension {}, searching for a suitable y-location", newSpawn.func_177958_n(), newSpawn.func_177952_p(), dimension);
                newSpawn = WorldUtils.getSuitableSpawnBlockInColumn(world, newSpawn, true, true);
            }
        } else if (dimension != 0 && Configs.enableSeparateWorldInfo && DimensionConfig.instance().useCustomWorldInfoFor(dimension) || searchType != null && searchType.getType() != SpawnPointSearch.Type.NONE) {
            JustEnoughDimensions.logInfo("WorldUtils.findAndSetWorldSpawn: Trying to find a world spawn for dimension {}...", dimension);
            newSpawn = WorldUtils.findSuitableSpawnpoint(world, searchType);
        }
        if (newSpawn != null) {
            WorldBorder border;
            if (!world.func_175694_M().equals(newSpawn)) {
                world.func_175652_B(newSpawn);
                JustEnoughDimensions.logInfo("WorldUtils.findAndSetWorldSpawn: Set the world spawnpoint of dimension {} to {}", dimension, newSpawn);
            }
            if (!(border = world.func_175723_af()).func_177746_a(newSpawn)) {
                border.func_177739_c((double)newSpawn.func_177958_n(), (double)newSpawn.func_177952_p());
                JustEnoughDimensions.logInfo("WorldUtils.findAndSetWorldSpawn: Moved the WorldBorder of dimension {} to the world's spawn, because the spawn was outside the border", dimension);
            }
        }
    }

    @Nonnull
    public static BlockPos findSuitableSpawnpoint(World world) {
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(world.field_73011_w.getDimension());
        SpawnPointSearch searchType = props != null ? props.getSpawnPointSearchType() : null;
        return WorldUtils.findSuitableSpawnpoint(world, searchType);
    }

    @Nonnull
    public static BlockPos findSuitableSpawnpoint(World world, @Nullable SpawnPointSearch searchType) {
        BlockPos pos;
        WorldProvider provider = world.field_73011_w;
        if (searchType != null) {
            JustEnoughDimensions.logInfo("WordlUtils.findSuitableSpawnpoint: Using a customized spawn point search type '{}' for DIM {}", searchType.toString(), provider.getDimension());
            switch (searchType.getType()) {
                case OVERWORLD: {
                    return WorldUtils.findOverworldSpawnpoint(world, searchType);
                }
                case CAVERN: {
                    return WorldUtils.findCavernSpawnpoint(world, searchType);
                }
                case NONE: {
                    JustEnoughDimensions.logInfo("WorldUtils.findSuitableSpawnpoint: SpawnPointSearch.Type == NONE, using the existing spawn point in DIM {}", provider.getDimension());
                    return world.func_175694_M();
                }
            }
        }
        if (provider.func_186058_p() == DimensionType.THE_END || provider instanceof WorldProviderEnd) {
            pos = provider.func_177496_h();
            if (pos == null) {
                pos = WorldUtils.getSuitableSpawnBlockInColumn(world, new BlockPos(0, 72, 0), true, true);
            }
        } else {
            pos = provider.func_186058_p() == DimensionType.NETHER || provider.func_177495_o() || provider instanceof WorldProviderHell || provider instanceof WorldProviderHellJED ? WorldUtils.findCavernSpawnpoint(world, searchType) : (world.func_72912_H().func_76067_t() == WorldType.field_180272_g ? BlockPos.field_177992_a.func_177981_b(64) : WorldUtils.findOverworldSpawnpoint(world, searchType));
        }
        WorldUtils.generateFallbackSpawnBlockIfEnabled(world, pos);
        return pos;
    }

    @Nonnull
    private static BlockPos findCavernSpawnpoint(World world, @Nullable SpawnPointSearch searchType) {
        Integer yRangeMax = searchType != null ? searchType.getMaxY() : null;
        int minY = searchType != null && searchType.getMinY() != null ? Math.max(1, searchType.getMinY()) : 30;
        Random random = new Random(world.func_72905_C());
        int x = 0;
        int z = 0;
        for (int iterations = 0; iterations < 200; ++iterations) {
            Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
            int maxY = 120;
            if (yRangeMax != null) {
                maxY = yRangeMax;
            }
            BlockPos pos = new BlockPos(x, maxY, z);
            while (pos.func_177956_o() >= minY) {
                IBlockState stateBelow = chunk.func_177435_g(pos.func_177979_c(2));
                IBlockState state1 = chunk.func_177435_g(pos.func_177979_c(1));
                IBlockState state2 = chunk.func_177435_g(pos);
                if (state1.func_177230_c().isAir(state1, (IBlockAccess)world, pos) && state2.func_177230_c().isAir(state2, (IBlockAccess)world, pos) && stateBelow.func_185904_a().func_76230_c()) {
                    return pos.func_177977_b();
                }
                pos = pos.func_177977_b();
            }
            x += random.nextInt(32) - random.nextInt(32);
            z += random.nextInt(32) - random.nextInt(32);
        }
        BlockPos pos = new BlockPos(0, 72, 0);
        JustEnoughDimensions.logger.warn("Unable to find a cavern type spawn point for dimension {}, defaulting to x = {}, y = {}, z = {}", (Object)world.field_73011_w.getDimension(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        WorldUtils.generateFallbackSpawnBlockIfEnabled(world, pos);
        return pos;
    }

    @Nonnull
    private static BlockPos findOverworldSpawnpoint(World world, @Nullable SpawnPointSearch searchType) {
        WorldProvider provider = world.field_73011_w;
        BiomeProvider biomeProvider = provider.func_177499_m();
        List list = biomeProvider.func_76932_a();
        Random random = new Random(world.func_72905_C());
        int x = 8;
        int z = 8;
        int minY = searchType != null && searchType.getMinY() != null ? Math.max(1, searchType.getMinY()) : 1;
        Integer yRangeMax = searchType != null ? searchType.getMaxY() : null;
        BlockPos pos = biomeProvider.func_180630_a(0, 0, 512, list, random);
        if (pos != null) {
            x = pos.func_177958_n();
            z = pos.func_177952_p();
        } else {
            JustEnoughDimensions.logger.warn("Unable to find spawn biome for dimension {}", (Object)provider.getDimension());
        }
        for (int iterations = 0; iterations < 1000; ++iterations) {
            if (provider.func_76566_a(x, z)) {
                Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
                int maxY = chunk.func_76625_h() + 15 + 1;
                if (yRangeMax != null) {
                    maxY = Math.min(yRangeMax, maxY);
                }
                pos = new BlockPos(x, maxY, z);
                while (pos.func_177956_o() >= minY) {
                    if (WorldUtils.isSuitableSpawnPosition(world, chunk, pos, false)) {
                        return pos;
                    }
                    pos = pos.func_177977_b();
                }
            }
            x += random.nextInt(32) - random.nextInt(32);
            z += random.nextInt(32) - random.nextInt(32);
        }
        pos = new BlockPos(x, 72, z);
        return WorldUtils.getSuitableSpawnBlockInColumn(world, pos, true, true);
    }

    @Nonnull
    public static BlockPos getSuitableSpawnBlockInColumn(World world, BlockPos originalPos, boolean leanient) {
        return WorldUtils.getSuitableSpawnBlockInColumn(world, originalPos, leanient, false);
    }

    @Nonnull
    public static BlockPos getSuitableSpawnBlockInColumn(World world, BlockPos originalPos, boolean leanient, boolean generateFallbackBlock) {
        BlockPos posTop;
        Chunk chunk = world.func_175726_f(originalPos);
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(world.field_73011_w.getDimension());
        SpawnPointSearch searchType = props != null ? props.getSpawnPointSearchType() : null;
        Integer yRangeMax = searchType != null ? searchType.getMaxY() : null;
        int minY = searchType != null && searchType.getMinY() != null ? Math.max(1, searchType.getMinY()) : 1;
        int maxY = chunk.func_76625_h() + 15 + 1;
        if (yRangeMax != null) {
            maxY = MathHelper.func_76125_a((int)maxY, (int)minY, (int)yRangeMax);
        }
        BlockPos pos = posTop = new BlockPos(originalPos.func_177958_n(), maxY, originalPos.func_177952_p());
        while (pos.func_177956_o() >= minY) {
            if (WorldUtils.isSuitableSpawnPosition(world, chunk, pos, leanient)) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        if (generateFallbackBlock) {
            WorldUtils.generateFallbackSpawnBlockIfEnabled(world, originalPos);
        }
        return originalPos;
    }

    private static boolean isSuitableSpawnPosition(World world, Chunk chunk, BlockPos pos, boolean leanient) {
        IBlockState state = chunk.func_177435_g(pos.func_177979_c(1));
        Material materialUp1 = chunk.func_177435_g(pos).func_185904_a();
        Material materialUp2 = chunk.func_177435_g(pos.func_177981_b(1)).func_185904_a();
        return !(!state.func_185904_a().func_76230_c() || !leanient && state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || !leanient && state.func_177230_c().isFoliage((IBlockAccess)world, pos) || materialUp1.func_76230_c() || !leanient && materialUp1.func_76224_d() || materialUp2.func_76230_c() || !leanient && materialUp2.func_76224_d());
    }

    private static void generateFallbackSpawnBlockIfEnabled(World world, BlockPos spawnPos) {
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(world.field_73011_w.getDimension());
        if (props != null && props.generateFallbackSpawnBlock() && world.func_175623_d(spawnPos.func_177977_b())) {
            int dim = world.field_73011_w.getDimension();
            JustEnoughDimensions.logInfo("Didn't find suitable spawn location in dim {}, generating a glass block under the spawn point", dim);
            world.func_175656_a(spawnPos.func_177977_b(), Blocks.field_150359_w.func_176223_P());
        }
    }

    public static void createBonusChest(World world) {
        int z;
        int x;
        BlockPos pos;
        WorldInfo info = world.func_72912_H();
        WorldGeneratorBonusChest gen = new WorldGeneratorBonusChest();
        for (int i = 0; i < 10 && !gen.func_180709_b(world, world.field_73012_v, pos = world.func_175672_r(new BlockPos(x = info.func_76079_c() + world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6), 0, z = info.func_76074_e() + world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6))).func_177984_a()); ++i) {
        }
    }

    private static void loadChunks(World world, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) {
        int xStart = Math.min(chunkX1, chunkX2);
        int zStart = Math.min(chunkZ1, chunkZ2);
        int xEnd = Math.max(chunkX1, chunkX2);
        int zEnd = Math.max(chunkZ1, chunkZ2);
        int dimension = world.field_73011_w.getDimension();
        JustEnoughDimensions.logInfo("Attempting to load chunks [{},{}] to [{},{}] in dimension {}", xStart, zStart, xEnd, zEnd, dimension);
        for (int x = xStart; x <= xEnd; ++x) {
            for (int z = zStart; z <= zEnd; ++z) {
                if (world.func_175667_e(new BlockPos(x << 4, 0, z << 4))) continue;
                world.func_72964_e(x, z);
            }
        }
    }

    private static void loadChunks(World world, BlockPos pos, BlockPos size, int expand) {
        int cx1 = pos.func_177958_n() - expand >> 4;
        int cz1 = pos.func_177952_p() - expand >> 4;
        int cx2 = pos.func_177958_n() + size.func_177958_n() + expand >> 4;
        int cz2 = pos.func_177952_p() + size.func_177952_p() + expand >> 4;
        WorldUtils.loadChunks(world, cx1, cz1, cx2, cz2);
    }

    public static void placeSpawnStructureIfApplicable(World world) {
        JsonObject spawnStructureJson;
        int dimension = world.field_73011_w.getDimension();
        boolean isDimensionInit = !WorldFileUtils.jedLevelFileExists(world);
        DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(dimension);
        if (isDimensionInit && entry != null && (spawnStructureJson = entry.getSpawnStructureJson()) != null) {
            StructurePlacement placement = StructurePlacement.fromJson(spawnStructureJson);
            if (placement != null) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                StructurePlacement.StructureType type = StructurePlacement.StructureType.fromFileName(placement.getFile().getName());
                BlockPos pos = world.func_175694_M().func_177971_a((Vec3i)placement.getOffset());
                boolean success = false;
                if (type == StructurePlacement.StructureType.STRUCTURE) {
                    JustEnoughDimensions.logInfo("WorldUtils.placeSpawnStructure: Trying to place the spawn structure at {}", pos);
                    success = WorldUtils.tryPlaceVanillaStructure(server, world, pos, placement);
                } else if (type == StructurePlacement.StructureType.SCHEMATIC) {
                    JustEnoughDimensions.logInfo("WorldUtils.placeSpawnStructure: Trying to place the spawn schematic at {}", pos);
                    success = WorldUtils.tryPlaceSchematic(server, world, pos, placement);
                } else if (type == StructurePlacement.StructureType.INVALID) {
                    JustEnoughDimensions.logger.warn("WorldUtils.placeSpawnStructure: Invalid structure type '{}'", (Object)placement.getFile().getAbsolutePath());
                }
                if (success) {
                    JustEnoughDimensions.logInfo("WorldUtils.placeSpawnStructure: Successfully placed the spawn structure in dimension {}", dimension);
                } else {
                    JustEnoughDimensions.logger.warn("WorldUtils.placeSpawnStructure: Failed to place the spawn structure in dimension {}", (Object)dimension);
                }
            } else {
                JustEnoughDimensions.logger.warn("WorldUtils.placeSpawnStructure: Spawn structure defined but failed to load in dimension {}", (Object)dimension);
            }
        }
    }

    private static boolean tryPlaceVanillaStructure(MinecraftServer server, World world, BlockPos pos, StructurePlacement placement) {
        File file = placement.getFile();
        if (!file.exists()) {
            return false;
        }
        String name = file.getName();
        name = name.substring(0, name.lastIndexOf("."));
        Template template = WorldUtils.getTemplateManager().func_186237_a(server, new ResourceLocation(name));
        if (template != null) {
            PlacementSettings placementSettings = new PlacementSettings();
            placementSettings.func_186220_a(placement.getRotation());
            placementSettings.func_186214_a(placement.getMirror());
            placementSettings.func_186225_a(Blocks.field_189881_dj);
            if (placement.isCentered()) {
                BlockPos size = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)template.func_186259_a());
                pos = pos.func_177982_a(-(size.func_177958_n() / 2), 0, -(size.func_177952_p() / 2));
            }
            WorldUtils.loadChunks(world, pos, template.func_186259_a(), placement.getLoadRangeAround());
            template.func_189962_a(world, pos, placementSettings, 18);
            return true;
        }
        return false;
    }

    private static boolean tryPlaceSchematic(MinecraftServer server, World world, BlockPos pos, StructurePlacement placement) {
        File file = new File(StructurePlacement.getStructureDirectory(), placement.getFile().getName());
        Schematic schematic = Schematic.createFromFile(file);
        if (schematic != null) {
            PlacementSettings placementSettings = new PlacementSettings();
            placementSettings.func_186220_a(placement.getRotation());
            placementSettings.func_186214_a(placement.getMirror());
            placementSettings.func_186225_a(Blocks.field_189881_dj);
            placementSettings.func_186222_a(false);
            if (placement.isCentered()) {
                BlockPos size = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)schematic.getSize());
                pos = pos.func_177982_a(-(size.func_177958_n() / 2), 0, -(size.func_177952_p() / 2));
            }
            WorldUtils.loadChunks(world, pos, schematic.getSize(), placement.getLoadRangeAround());
            schematic.placeSchematicToWorld(world, pos, placementSettings, 2);
            return true;
        }
        return false;
    }

    private static TemplateManager getTemplateManager() {
        return new TemplateManager(StructurePlacement.getStructureDirectory().toString(), (DataFixer)FMLCommonHandler.instance().getDataFixer());
    }

    public static void setupRespawnDimension(EntityPlayer player) {
        World world = player.func_130014_f_();
        int dim = world.field_73011_w.getDimension();
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(dim);
        if (!world.field_73011_w.func_76567_e() && props != null && props.canRespawnHere() != null && props.canRespawnHere().booleanValue()) {
            JustEnoughDimensions.logInfo("WorldUtils.setupRespawnDimension: Setting the respawn dimension of player '{}' to: {}", player.func_70005_c_(), dim);
            player.setSpawnDimension(Integer.valueOf(dim));
            player.func_184211_a(JED_RESPAWN_DIM_TAG);
        } else if (player.func_184216_O().contains(JED_RESPAWN_DIM_TAG)) {
            JustEnoughDimensions.logInfo("WorldUtils.setupRespawnDimension: Removing the respawn dimension data from player '{}'", player.func_70005_c_());
            player.setSpawnDimension(null);
            player.func_184197_b(JED_RESPAWN_DIM_TAG);
        }
    }

    public static boolean canBlockFreeze(World world, BlockPos pos, boolean noWaterAdj) {
        IBlockState state;
        Block block;
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (!noWaterAdj) {
                return true;
            }
            return !WorldUtils.isWater(world, pos.func_177976_e()) || !WorldUtils.isWater(world, pos.func_177974_f()) || !WorldUtils.isWater(world, pos.func_177978_c()) || !WorldUtils.isWater(world, pos.func_177968_d());
        }
        return false;
    }

    public static boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public static boolean canSnowAt(World world, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10) {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && Blocks.field_150431_aC.func_176196_c(world, pos);
        }
        return false;
    }

    static {
        try {
            field_World_provider = ObfuscationReflectionHelper.findField(World.class, (String)"field_73011_w");
            field_WorldProvider_biomeProvider = ObfuscationReflectionHelper.findField(WorldProvider.class, (String)"field_76578_c");
            field_ChunkProviderServer_chunkGenerator = ObfuscationReflectionHelper.findField(ChunkProviderServer.class, (String)"field_186029_c");
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.error("WorldUtils: Reflection failed!!", (Throwable)e);
        }
    }
}

