/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.util.ClientStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CUpdateDodgeMessage
implements IMessage {
    private int dodges;
    private boolean messageValid;

    public CUpdateDodgeMessage() {
        this.messageValid = false;
    }

    public CUpdateDodgeMessage(int dodges) {
        this.dodges = dodges;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dodges = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.dodges);
    }

    public static class Handler
    implements IMessageHandler<CUpdateDodgeMessage, IMessage> {
        public IMessage onMessage(CUpdateDodgeMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CUpdateDodgeMessage message, MessageContext ctx) {
            ClientStorage.dodges = message.dodges;
        }
    }
}

