/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.event.ArmorTickEventListener;
import com.elenai.elenaidodge2.util.ClientStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CUpdateConfigMessage
implements IMessage {
    private int regenRate;
    private int dodges;
    private int absorption;
    private String weights;
    private boolean half;
    private boolean tanEnabled;
    private boolean messageValid;

    public CUpdateConfigMessage() {
        this.messageValid = false;
    }

    public CUpdateConfigMessage(int regenRate, int dodges, String weights, boolean half, int absorption, boolean tanEnabled) {
        this.regenRate = regenRate;
        this.dodges = dodges;
        this.weights = weights;
        this.half = half;
        this.absorption = absorption;
        this.tanEnabled = tanEnabled;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.regenRate = buf.readInt();
            this.dodges = buf.readInt();
            this.weights = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.half = buf.readBoolean();
            this.absorption = buf.readInt();
            this.tanEnabled = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.regenRate);
        buf.writeInt(this.dodges);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.weights);
        buf.writeBoolean(this.half);
        buf.writeInt(this.absorption);
        buf.writeBoolean(this.tanEnabled);
    }

    public static class Handler
    implements IMessageHandler<CUpdateConfigMessage, IMessage> {
        public IMessage onMessage(CUpdateConfigMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CUpdateConfigMessage message, MessageContext ctx) {
            ClientStorage.regenSpeed = message.regenRate;
            if (message.dodges != 9999) {
                ClientStorage.dodges = message.dodges;
                ClientStorage.absorption = message.absorption;
            }
            ClientStorage.weightValues = message.weights;
            ClientStorage.halfFeathers = message.half;
            ClientStorage.tanEnabled = message.tanEnabled;
            ArmorTickEventListener.previousArmor.clear();
        }
    }
}

