/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.util.PatronRewardHandler;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CPatronMessage
implements IMessage {
    private int level;
    private boolean messageValid;

    public CPatronMessage() {
        this.messageValid = false;
    }

    public CPatronMessage(int level) {
        this.level = level;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.level = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.level);
    }

    public static class Handler
    implements IMessageHandler<CPatronMessage, IMessage> {
        public IMessage onMessage(CPatronMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CPatronMessage message, MessageContext ctx) {
            PatronRewardHandler.localPatronTier = message.level == 99 ? 4 : message.level;
        }
    }
}

