/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.effects.ClientDodgeEffects;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CDodgeEffectsMessage
implements IMessage {
    private int dodges;
    private int absorption;
    private boolean messageValid;

    public CDodgeEffectsMessage() {
        this.messageValid = false;
    }

    public CDodgeEffectsMessage(int dodges, int absorption) {
        this.dodges = dodges;
        this.absorption = absorption;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dodges = buf.readInt();
            this.absorption = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.dodges);
        buf.writeInt(this.absorption);
    }

    public static class Handler
    implements IMessageHandler<CDodgeEffectsMessage, IMessage> {
        public IMessage onMessage(CDodgeEffectsMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CDodgeEffectsMessage message, MessageContext ctx) {
            ClientDodgeEffects.run(message.dodges, message.absorption);
        }
    }
}

