/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.gui;

import com.elenai.elenaidodge2.ModConfig;
import com.elenai.elenaidodge2.util.ClientStorage;
import com.elenai.elenaidodge2.util.PatronRewardHandler;
import com.elenai.elenaidodge2.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DodgeGui {
    public static ResourceLocation DODGE_ICONS = new ResourceLocation("elenaidodge2", "textures/gui/icons.png");
    public static ResourceLocation ADVANCED_DODGE_ICONS = new ResourceLocation("elenaidodge2", "textures/gui/advanced_icons.png");
    public static float alpha = 1.0f;

    @SubscribeEvent
    public void onRenderDodgeGUIEvent(RenderGameOverlayEvent.Post event) {
        if (ModConfig.client.hud.hud && !Minecraft.func_71410_x().field_71439_g.func_184812_l_() && !Minecraft.func_71410_x().field_71439_g.func_175149_v() && Utils.dodgeTraitUnlocked((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && (event.getType() == RenderGameOverlayEvent.ElementType.ALL && ModConfig.client.hud.compatHud || event.getType() == RenderGameOverlayEvent.ElementType.FOOD && !ModConfig.client.hud.compatHud)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DODGE_ICONS);
            GlStateManager.func_179147_l();
            DodgeGui.enableAlpha(alpha);
            if (alpha > 0.0f) {
                DodgeGui.renderFeathers(event.getResolution().func_78328_b(), event.getResolution().func_78326_a(), ClientStorage.dodges, ClientStorage.weight, ClientStorage.healing, 16, 25, 34, 43, 52, 61, 70, PatronRewardHandler.localPatronTier);
                DodgeGui.renderAbsorptionFeathers(event.getResolution().func_78328_b(), event.getResolution().func_78326_a(), ClientStorage.absorption, ClientStorage.weight, ClientStorage.healing, 79, 88);
            }
            DodgeGui.disableAlpha(alpha);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
        }
    }

    public static void renderFeathers(int screenHeight, int screenWidth, int dodges, int weight, boolean healing, int noFeather, int halfFeather, int fullFeather, int armoredFeather, int halfArmoredFeather, int halfMixedFeather, int mixedFeather, int patronLevel) {
        int rows;
        GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
        if (patronLevel > 4 && patronLevel != 99) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ADVANCED_DODGE_ICONS);
            patronLevel -= 5;
            patronLevel *= 9;
        } else if (patronLevel > 0 && patronLevel != 99) {
            ++patronLevel;
            patronLevel *= 9;
        }
        if (patronLevel == 99) {
            patronLevel = 5;
            patronLevel *= 9;
        }
        if ((rows = MathHelper.func_76123_f((float)((float)dodges / 20.0f))) <= 0) {
            rows = 1;
        }
        int rowHeight = Math.min(Math.max(10 - (rows - 2), 3), 10);
        int top = screenHeight - GuiIngameForge.right_height - (rows * rowHeight - 10) + ModConfig.client.hud.yOffset;
        for (int i = rows - 1; i >= 0; --i) {
            int right = screenWidth / 2 + 82 + ModConfig.client.hud.xOffset;
            for (int j = 1; j < 20; j += 2) {
                if (j + i * 20 < dodges) {
                    if (j + i * 20 > weight) {
                        gui.func_73729_b(right, top, fullFeather, patronLevel, 9, 9);
                    } else if (j + i * 20 == weight) {
                        gui.func_73729_b(right, top, mixedFeather, patronLevel, 9, 9);
                    } else {
                        gui.func_73729_b(right, top, armoredFeather, patronLevel, 9, 9);
                    }
                } else if (j + i * 20 == dodges) {
                    if (j + i * 20 > weight) {
                        gui.func_73729_b(right, top, halfFeather, patronLevel, 9, 9);
                    } else if (j + i * 20 == weight) {
                        gui.func_73729_b(right, top, halfMixedFeather, patronLevel, 9, 9);
                    } else {
                        gui.func_73729_b(right, top, halfArmoredFeather, patronLevel, 9, 9);
                    }
                } else if (j + i * 20 > dodges) {
                    gui.func_73729_b(right, top, noFeather, patronLevel, 9, 9);
                }
                if (healing) {
                    gui.func_73729_b(right, top, 16, 9, 9, 9);
                } else if (ClientStorage.failed && ModConfig.client.hud.flash) {
                    gui.func_73729_b(right, top, 43, 9, 9, 9);
                }
                right -= 8;
            }
            top += rowHeight;
            GuiIngameForge.right_height += rowHeight;
        }
        if (rowHeight < 10) {
            GuiIngameForge.right_height += 10 - rowHeight;
        }
    }

    public static void renderAbsorptionFeathers(int screenHeight, int screenWidth, int dodges, int weight, boolean healing, int halfFeather, int fullFeather) {
        GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
        int rows = MathHelper.func_76123_f((float)((float)dodges / 20.0f));
        int rowHeight = Math.min(Math.max(10 - (rows - 2), 3), 10);
        int top = screenHeight - GuiIngameForge.right_height - (rows * rowHeight - 10) + ModConfig.client.hud.yOffset;
        for (int i = rows - 1; i >= 0; --i) {
            int right = screenWidth / 2 + 82 + ModConfig.client.hud.xOffset;
            for (int j = 1; j < 20; j += 2) {
                if (j + i * 20 < dodges) {
                    gui.func_73729_b(right, top, fullFeather, 0, 9, 9);
                } else if (j + i * 20 == dodges) {
                    gui.func_73729_b(right, top, halfFeather, 0, 9, 9);
                }
                right -= 8;
            }
            top += rowHeight;
            GuiIngameForge.right_height += rowHeight;
        }
        if (rowHeight < 10) {
            GuiIngameForge.right_height += 10 - rowHeight;
        }
    }

    public static void enableAlpha(float alpha) {
        GlStateManager.func_179147_l();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        GlStateManager.func_179084_k();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

