/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2;

import net.minecraftforge.common.config.Config;

@Config(modid="elenaidodge2", name="Elenai Dodge 2", type=Config.Type.INSTANCE)
public class ModConfig {
    public static Client client = new Client();
    public static Common common = new Common();

    public static class Common {
        public Balance balance = new Balance();
        public Feathers feathers = new Feathers();
        public Weights weights = new Weights();
        public Misc misc = new Misc();
        public Integration integration = new Integration();

        public class Integration {
            public ToughAsNails toughAsNails = new ToughAsNails();

            public class ToughAsNails {
                @Config.Name(value="Exhaustion")
                @Config.Comment(value={"How much exhaustion (thirstiness) is added when the player regenerates a dodge feather."})
                @Config.RangeDouble(min=0.0, max=40.0)
                public double exhaustion = 6.0;
                @Config.Name(value="Enabled")
                @Config.Comment(value={"Whether to enable Tough as Nails support"})
                public boolean enabled = true;
            }
        }

        public class Misc {
            @Config.Name(value="Overwhelmed Message")
            @Config.Comment(value={"Whether the Player is notified when the Endurance Effect is overpowered by the Heavy Effect."})
            public boolean message = true;
            @Config.Name(value="Nether Dodge")
            @Config.Comment(value={"Whether the Player dodges further in the Nether."})
            public boolean nether = true;
            @Config.Name(value="End Dodge")
            @Config.Comment(value={"Whether the Player dodge is weaker in the End."})
            public boolean end = true;
            @Config.Name(value="Enable Particles")
            @Config.Comment(value={"Whether the Player's dodge creates a puff of smoke."})
            public boolean particles = true;
        }

        public class Weights {
            @Config.Name(value="Weights Override")
            @Config.Comment(value={"The weight of each item of Armor. This overrides the default generated values. Each 'Steel Feather' is equivalent to a weight of 2. Insert values as such: modid:itemname=value. Any item with a weight over 24 will not show its weight as a tooltip. Idea Credit: SandwichHorror"})
            public String[] weights = new String[]{"minecraft:leather_boots=1", "minecraft:leather_leggings=2", "minecraft:leather_chestplate=3", "minecraft:leather_helmet=1", "minecraft:iron_boots=2", "minecraft:iron_leggings=3", "minecraft:iron_chestplate=5", "minecraft:iron_helmet=3", "minecraft:diamond_boots=3", "minecraft:diamond_leggings=4", "minecraft:diamond_chestplate=6", "minecraft:diamond_helmet=3", "minecraft:golden_boots=2", "minecraft:golden_leggings=2", "minecraft:golden_chestplate=3", "minecraft:golden_helmet=2", "minecraft:chainmail_boots=2", "minecraft:chainmail_leggings=2", "minecraft:chainmail_chestplate=3", "minecraft:chainmail_helmet=2", "minecraft:elytra=2", "twilightforest:naga_chestplate=3", "twilightforest:naga_leggings=2", "twilightforest:ironwood_helmet=2", "twilightforest:ironwood_chestplate=5", "twilightforest:ironwood_leggings=3", "twilightforest:ironwood_boots=2", "twilightforest:fiery_helmet=3", "twilightforest:fiery_chestplate=7", "twilightforest:fiery_leggings=4", "twilightforest:fiery_boots=3", "twilightforest:steeleaf_helmet=3", "twilightforest:steeleaf_chestplate=5", "twilightforest:steeleaf_leggings=4", "twilightforest:steeleaf_boots=3", "twilightforest:knightmetal_helmet=3", "twilightforest:knightmetal_chestplate=7", "twilightforest:knightmetal_leggings=5", "twilightforest:knightmetal_boots=2", "twilightforest:yeti_helmet=2", "twilightforest:yeti_chestplate=5", "twilightforest:yeti_leggings=3", "twilightforest:yeti_boots=2", "twilightforest:arctic_helmet=1", "twilightforest:arctic_chestplate=3", "twilightforest:arctic_leggings=2", "twilightforest:arctic_boots=1", "betterwithmods:steel_helmet=3", "betterwithmods:steel_chest=7", "betterwithmods:steel_pants=4", "betterwithmods:steel_boots=2", "atop:amethyst_helmet=3", "atop:amethyst_chestplate=6", "atop:amethyst_leggings=5", "atop:amethyst_boots=3", "atop:mud_helmet=1", "atop:mud_chestplate=3", "atop:mud_leggings=2", "atop:mud_boots=1", "atop:peridot_helmet=3", "atop:peridot_chestplate=6", "atop:peridot_leggings=4", "atop:peridot_boots=3", "atop:ruby_helmet=3", "atop:ruby_chestplate=6", "atop:ruby_leggings=4", "atop:ruby_boots=3", "atop:sapphire_helmet=3", "atop:sapphire_chestplate=6", "atop:sapphire_leggings=4", "atop:sapphire_boots=3  ", "quark:archaeologist_hat=0.25", "quark:pirate_hat=0.25", "quark:witch_hat=0.25", "dungeontactics:steel_helmet=3", "dungeontactics:steel_chestplate=6", "dungeontactics:steel_leggings=5", "dungeontactics:steel_boots=2", "endreborn:armour_helmet_helmet=5", "endreborn:armour_helmet_obsidian=5", "endreborn:armour_chestplate_obsidian=10", "endreborn:armour_leggings_obsidian=7", "endreborn:armour_boots_obsidian=4", "mod_lavacow:felarmor_helmet=1", "mod_lavacow:felarmor_chestplate=3", "mod_lavacow:felarmor_leggings=2", "mod_lavacow:felarmor_boots=1", "mod_lavacow:swinemask=0.25", "mod_lavacow:swinearmor_chestplate=3", "mod_lavacow:swinearmor_leggings=2", "mod_lavacow:swinearmor_boots=1", "mod_lavacow:faminearmor_helmet=1", "mod_lavacow:faminearmor_chestplate=2", "mod_lavacow:faminearmor_leggings=1", "mod_lavacow:faminearmor_boots=0.5", "iceandfire:armor_silver_metal_helmet=1", "iceandfire:armor_silver_metal_chestplate=3", "iceandfire:armor_silver_metal_leggings=2", "iceandfire:armor_silver_metal_boots=1", "iceandfire:deathworm_yellow_helmet=1", "iceandfire:deathworm_yellow_chestplate=3", "iceandfire:deathworm_yellow_leggings=2", "iceandfire:deathworm_yellow_boots=1", "iceandfire:deathworm_white_helmet=1", "iceandfire:deathworm_white_chestplate=3", "iceandfire:deathworm_white_leggings=2", "iceandfire:deathworm_white_boots=1", "iceandfire:deathworm_red_helmet=1", "iceandfire:deathworm_red_chestplate=3", "iceandfire:deathworm_red_leggings=2", "iceandfire:deathworm_red_boots=1", "iceandfire:myrmex_desert_helmet=1", "iceandfire:myrmex_desert_chestplate=2", "iceandfire:myrmex_desert_leggings=1.5", "iceandfire:myrmex_desert_boots=0.5", "iceandfire:myrmex_jungle_helmet=1", "iceandfire:myrmex_jungle_chestplate=2", "iceandfire:myrmex_jungle_leggings=1.5", "iceandfire:myrmex_jungle_boots=0.5", "iceandfire:dragonsteel_fire_helmet=3", "iceandfire:dragonsteel_fire_chestplate=7", "iceandfire:dragonsteel_fire_leggings=5", "iceandfire:dragonsteel_fire_boots=3", "iceandfire:dragonsteel_ice_helmet=3", "iceandfire:dragonsteel_ice_chestplate=7", "iceandfire:dragonsteel_ice_leggings=5", "iceandfire:dragonsteel_ice_boots=3", "iceandfire:armor_red_helmet=2", "iceandfire:armor_red_chestplate=3", "iceandfire:armor_red_leggings=2", "iceandfire:armor_red_boots=1", "iceandfire:armor_bronze_helmet=2", "iceandfire:armor_bronze_chestplate=3", "iceandfire:armor_bronze_leggings=2", "iceandfire:armor_bronze_boots=1", "iceandfire:armor_green_helmet=2", "iceandfire:armor_green_chestplate=3", "iceandfire:armor_green_leggings=2", "iceandfire:armor_green_boots=1", "iceandfire:armor_gray_helmet=2", "iceandfire:armor_gray_chestplate=3", "iceandfire:armor_gray_leggings=2", "iceandfire:armor_gray_boots=1", "iceandfire:armor_blue_helmet=2", "iceandfire:armor_blue_chestplate=3", "iceandfire:armor_blue_leggings=2", "iceandfire:armor_blue_boots=1", "iceandfire:armor_white_helmet=2", "iceandfire:armor_white_chestplate=3", "iceandfire:armor_white_leggings=2", "iceandfire:armor_white_boots=1", "iceandfire:armor_sapphire_helmet=2", "iceandfire:armor_sapphire_chestplate=3", "iceandfire:armor_sapphire_leggings=2", "iceandfire:armor_sapphire_boots=1", "iceandfire:armor_silver_helmet=2", "iceandfire:armor_silver_chestplate=3", "iceandfire:armor_silver_leggings=2", "iceandfire:armor_silver_boots=1", "iceandfire:tide_blue_helmet=0.5", "iceandfire:tide_blue_chestplate=2", "iceandfire:tide_blue_leggings=1", "iceandfire:tide_blue_boots=0.5", "iceandfire:tide_bronze_helmet=0.5", "iceandfire:tide_bronze_chestplate=2", "iceandfire:tide_bronze_leggings=1", "iceandfire:tide_bronze_boots=0.5", "iceandfire:tide_deepblue_helmet=0.5", "iceandfire:tide_deepblue_chestplate=2", "iceandfire:tide_deepblue_leggings=1", "iceandfire:tide_deepblue_boots=0.5", "iceandfire:tide_green_helmet=0.5", "iceandfire:tide_green_chestplate=2", "iceandfire:tide_green_leggings=1", "iceandfire:tide_green_boots=0.5", "iceandfire:tide_purple_helmet=0.5", "iceandfire:tide_purple_chestplate=2", "iceandfire:tide_purple_leggings=1", "iceandfire:tide_purple_boots=0.5", "iceandfire:tide_red_helmet=0.5", "iceandfire:tide_red_chestplate=2", "iceandfire:tide_red_leggings=1", "iceandfire:tide_red_boots=0.5", "iceandfire:tide_teal_helmet=0.5", "iceandfire:tide_teal_chestplate=2", "iceandfire:tide_teal_leggings=1", "iceandfire:tide_teal_boots=0.5", "iceandfire:forest_troll_leather_helmet=1", "iceandfire:forest_troll_leather_chestplate=3", "iceandfire:forest_troll_leather_leggings=2", "iceandfire:forest_troll_leather_boots=1", "iceandfire:frost_troll_leather_helmet=1", "iceandfire:frost_troll_leather_chestplate=3", "iceandfire:frost_troll_leather_leggings=2", "iceandfire:frost_troll_leather_boots=1", "iceandfire:mountain_troll_leather_helmet=1", "iceandfire:mountain_troll_leather_chestplate=3", "iceandfire:mountain_troll_leather_leggings=2", "iceandfire:mountain_troll_leather_boots=1", "iceandfire:sheep_helmet=0.25", "iceandfire:sheep_chestplate=1", "iceandfire:sheep_leggings=0.5", "iceandfire:sheep_boots=0.25", "mowziesmobs:wrought_helmet=2", "mowziesmobs:barako_mask=1", "mowziesmobs:barakoa_mask_fury=0.25", "mowziesmobs:barakoa_mask_fear=0.25", "mowziesmobs:barakoa_mask_rage=0.25", "mowziesmobs:barakoa_mask_misery=0.25", "netherex:wither_bone_helmet=0.25", "netherex:wither_bone_chestplate=2", "netherex:wither_bone_leggings=1", "netherex:wither_bone_boots=0.25", "primitivemobs:camouflage_helmet=0.15", "primitivemobs:camouflage_chestplate=1", "primitivemobs:camouflage_boots=0.15", "primitivemobs:camouflage_leggings=0.5", "rats:farmer_hat=0.1", "rats:fisherman_hat=0.1", "rats:top_hat=0.1", "rats:santa_hat=0.1", "rats:plague_doctor_mask=0.15", "rats:black_death_mask=0.15", "simpleores:mythril_helmet=1", "simpleores:mythril_chestplate=2", "simpleores:mythril_leggings=1", "simpleores:mythril_boots=0.5", "simpleores:adamantium_helmet=1", "simpleores:adamantium_chestplate=3", "simpleores:adamantium_leggings=2", "simpleores:adamantium_boots=1", "simpleores:onyx_helmet=5", "simpleores:onyx_chestplate=7", "simpleores:onyx_leggings=6", "simpleores:onyx_boots=5", "toroquest:toro_armor_boots=0.1", "toroquest:toro_armor_leggings=0.5", "toroquest:toro_armor_helmet=0.1", "toroquest:toro_armor_chestplate=1", "toroquest:royal_boots=0.25", "toroquest:royal_leggings=1", "toroquest:royal_helmet=0.25", "toroquest:royal_chestplate=2", "toroquest:legendary_bandit_helmet=0.1", "toroquest:samurai_boots=0.15", "toroquest:samurai_leggings=0.45", "toroquest:samurai_helmet=0.15", "toroquest:samurai_chestplate=1", "betteranimalsplus:hirschgeistskullwearable=0.5", "aether_legacy:zanite_helmet=3", "aether_legacy:zanite_chestplate=6", "aether_legacy:zanite_leggings=4", "aether_legacy:zanite_boots=2", "aether_legacy:gravitite_helmet=3", "aether_legacy:gravitite_chestplate=5", "aether_legacy:gravitite_leggings=2", "aether_legacy:gravitite_boots=0.5", "aether_legacy:neptune_helmet=1", "aether_legacy:neptune_chestplate=4", "aether_legacy:neptune_leggings=2", "aether_legacy:neptune_boots=1", "aether_legacy:phoenix_helmet=0.25", "aether_legacy:phoenix_chestplate=1", "aether_legacy:phoenix_leggings=0.5", "aether_legacy:phoenix_boots=0.25", "aether_legacy:valkyrie_helmet=2", "aether_legacy:valkyrie_chestplate=4", "aether_legacy:valkyrie_leggings=3", "aether_legacy:valkyrie_boots=2", "aether_legacy:sentry_boots=2", "defiledlands:scale_boots=2", "defiledlands:scale_leggings=3", "defiledlands:scale_chestplate=5", "defiledlands:scale_helmet=3", "defiledlands:scale_golden_boots=2", "defiledlands:scale_golden_leggings=3", "defiledlands:scale_golden_chestplate=5", "defiledlands:scale_golden_helmet=3", "nyx:meteor_boots=3", "nyx:meteor_pants=4", "nyx:meteor_chest=6", "nyx:meteor_helm=3", "ceramics:clay_boots=1", "ceramics:clay_leggings=2", "ceramics:clay_chestplate=3", "ceramics:clay_helmet=1", "dungeontactics:bounce_boots=2"};
        }

        public class Feathers {
            @Config.Name(value="Cost")
            @Config.Comment(value={"How many half feathers dodging requires."})
            @Config.RangeInt(min=0, max=20)
            public int cost = 2;
            @Config.Name(value="Airborne Cost")
            @Config.Comment(value={"How many half feathers dodging midair requires. [Dodge Whilst Airborne must be Enabled]"})
            @Config.RangeInt(min=0, max=20)
            public int airborneCost = 4;
            @Config.Name(value="Regeneration Rate")
            @Config.Comment(value={"The amount of ticks required to regenerate half a feather. Please only change this when you have full feathers."})
            @Config.RangeInt(min=1, max=0x7FFFFFFF)
            public int rate = 80;
            @Config.Name(value="Half Feathers")
            @Config.Comment(value={"Whether to enable 'Half Feathers'. Instead of weight values rounding down, they will instead show as a half feather. These can be used if the 'Cost' value is set to an odd number."})
            public boolean half = false;
        }

        public class Balance {
            @Config.Name(value="Force")
            @Config.Comment(value={"The force of the player's dodge before any multipliers have been applied. This value is very sensitive."})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double force = 0.6;
            @Config.Name(value="Verticality")
            @Config.Comment(value={"How high the player is pushed from the ground when dodging. This value is proportional distance dodged due to friction."})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double verticality = 0.25;
            @Config.Name(value="Exhaustion")
            @Config.Comment(value={"How much exhaustion is added when dodging. For reference, sprinting adds 0.01 exhaustion per meter, and the Hunger effect adds 0.1 per second."})
            @Config.RangeDouble(min=0.0, max=40.0)
            public double exhaustion = 0.4;
            @Config.Name(value="Hunger Requirement")
            @Config.Comment(value={"How many half drumsticks the player needs to dodge. The default six is the same as sprinting."})
            @Config.RangeInt(min=-1, max=20)
            public int hunger = 6;
            @Config.Name(value="Enable whilst Sneaking")
            @Config.Comment(value={"Whether the player can dodge whilst sneaking."})
            public boolean enableWhilstSneaking = false;
            @Config.Name(value="Enable whilst Blocking")
            @Config.Comment(value={"Whether the player can dodge whilst blocking."})
            public boolean enableWhilstBlocking = false;
            @Config.Name(value="Enable whilst Airborne")
            @Config.Comment(value={"Whether the player can dodge whilst airborne."})
            public boolean enableWhilstAirborne = false;
            @Config.Name(value="Invincibility Ticks")
            @Config.Comment(value={"How many in-game ticks of invincibility the player has after dodging. 20 ticks is 1 second."})
            @Config.RangeInt(min=0, max=100)
            public int invincibilityTicks = 10;
            @Config.Name(value="Potion Blacklist")
            @Config.Comment(value={"Potions that prevent the player from dodging. Insert values in the format modid:potion. Idea Credit: SandwichHorror"})
            public String[] potions = new String[0];
        }
    }

    public static class Client {
        public Controls controls = new Controls();
        public Hud hud = new Hud();

        public class Hud {
            @Config.Name(value="Show HUD")
            @Config.Comment(value={"Whether to show the feathers in the UI."})
            public boolean hud = true;
            @Config.Name(value="Compatibility HUD")
            @Config.Comment(value={"Whether to enable compatibility mode for the HUD. If it isn't working as expected, try this."})
            public boolean compatHud = false;
            @Config.Name(value="Fadeout Inactive HUD")
            @Config.Comment(value={"Whether the GUI fades out when it is inactive."})
            public boolean fadeout = false;
            @Config.Name(value="Visual Dodge Failure")
            @Config.Comment(value={"Whether the feather bar will flash when the player attempts to dodge without the required feathers or too high a weight."})
            public boolean flash = false;
            @Config.Name(value="Show Tutorial")
            @Config.Comment(value={"Whether to show the tutorial on joining a new world."})
            public boolean tutorial = true;
            @Config.Name(value="Show Tooltips")
            @Config.Comment(value={"Whether to show armor weight tooltips. If Quark is installed, please restart the game after disabling or enabling 'Quark Settings -> Client -> Visual Stat Display'."})
            public boolean tooltips = true;
            @Config.Name(value="X Offset")
            @Config.Comment(value={"The X-Offset of the Feather Bar."})
            @Config.RangeInt(min=-2147483648, max=0x7FFFFFFF)
            public int xOffset = 0;
            @Config.Name(value="Y Offset")
            @Config.Comment(value={"The Y-Offset of the Feather Bar."})
            @Config.RangeInt(min=-2147483648, max=0x7FFFFFFF)
            public int yOffset = 0;
        }

        public class Controls {
            @Config.Name(value="Enable Double Tap")
            @Config.Comment(value={"Enable to make dodging left, right or backwards require a double tap, and forwards require a tap of a movement key."})
            public boolean doubleTap = false;
            @Config.Name(value="Double Tap Ticks")
            @Config.Comment(value={"How many system ticks you have between double tapping (these are faster than Minecraft ticks)."})
            @Config.RangeInt(min=1, max=0x7FFFFFFF)
            public int doubleTapTicks = 200;
            @Config.Name(value="Forwards Double Tap")
            @Config.Comment(value={"Enable to make dodging forwards require a double tap of a movement key. 'Enable Double Tap' must be enabled."})
            public boolean doubleTapForwards = false;
        }
    }
}

