/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script.rule;

import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.stackup.StackUpHelpers;
import pl.asie.stackup.script.rule.Rule;

public class RuleChangeStackSize
extends Rule {
    private Item item;
    private int newStackSize;
    private int oldValue;

    public RuleChangeStackSize() {
    }

    public RuleChangeStackSize(Item item, int newStackSize) {
        this.item = item;
        this.newStackSize = newStackSize;
    }

    @Override
    protected boolean applyInternal() {
        if (this.newStackSize < 0 || this.newStackSize > StackUpHelpers.getMaxStackSize()) {
            return false;
        }
        this.oldValue = this.item.func_77639_j();
        this.item.func_77625_d(this.newStackSize);
        return this.newStackSize == this.oldValue || this.item.func_77639_j() != this.oldValue;
    }

    @Override
    protected boolean undoInternal() {
        int oldValueCmp = this.item.func_77639_j();
        this.item.func_77625_d(this.oldValue);
        return oldValueCmp == this.oldValue || this.item.func_77639_j() != oldValueCmp;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", this.item.getRegistryName().toString());
        compound.func_74768_a("size", this.newStackSize);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("id")));
        this.newStackSize = nbt.func_74762_e("size");
    }
}

