/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.stackup.StackUpConfig;
import pl.asie.stackup.StackUpCore;
import pl.asie.stackup.core.ItemStackPatch;
import pl.asie.stackup.core.MaxStackConstantPatch;
import pl.asie.stackup.core.NetHandlerPlayServerPatch;
import pl.asie.stackup.core.RenderEntityItemPatch;
import pl.asie.stackup.core.RenderItemPatch;
import pl.asie.stackup.core.StackUpClassTracker;

public class StackUpTransformer
implements IClassTransformer {
    public boolean hasClass(String s) {
        try {
            Class.forName(s);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Consumer<ClassNode> consumer;
        transformedName = transformedName.replace('/', '.');
        byte[] data = basicClass;
        Consumer<ClassNode> emptyConsumer = consumer = n -> {};
        if (StackUpClassTracker.isImplements(transformedName, "net.minecraft.inventory.IInventory")) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("getInventoryStackLimit", "func_70297_j_"));
        }
        if (StackUpClassTracker.isImplements(transformedName, "net.minecraftforge.items.IItemHandler")) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("getSlotLimit"));
        }
        if (StackUpClassTracker.isExtends(transformedName, "net.minecraft.inventory.Slot")) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("getItemStackLimit", "func_178170_b", "getSlotStackLimit", "func_75219_a"));
        }
        if (StackUpConfig.coremodPatchRefinedStorage && transformedName.startsWith("com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler")) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("onExtract"));
        } else if (StackUpConfig.coremodPatchMantle && "slimeknights.mantle.tileentity.TileInventory".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("<init>"));
        } else if (StackUpConfig.coremodPatchIc2 && "ic2.core.block.invslot.InvSlot".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("<init>"));
        } else if (StackUpConfig.coremodPatchAppliedEnergistics2 && "appeng.tile.inventory.AppEngInternalInventory".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("<init>"));
        } else if (StackUpConfig.coremodPatchAppliedEnergistics2 && "appeng.tile.inventory.AppEngInternalAEInventory".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("<init>"));
        } else if (StackUpConfig.coremodPatchActuallyAdditions && "de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("getMaxStackSize"));
        } else if ("net.minecraft.client.renderer.entity.RenderEntityItem".equals(transformedName)) {
            consumer = consumer.andThen(node -> {
                StackUpTransformer.spliceClasses(node, "pl.asie.stackup.core.RenderEntityItemSplice", "getModelCount", "func_177078_a");
                RenderEntityItemPatch.patchDistanceConstant(node);
            });
        } else if ("net.minecraft.inventory.InventoryHelper".equals(transformedName)) {
            consumer = consumer.andThen(node -> StackUpTransformer.spliceClasses(node, "pl.asie.stackup.core.InventoryHelperPerformanceSplice", "spawnItemStack", "func_180173_a"));
        } else if ("net.minecraft.util.ServerRecipeBookHelper".equals(transformedName)) {
            consumer = consumer.andThen(MaxStackConstantPatch.patchMaxLimit("func_194324_a"));
        } else if ("net.minecraft.network.PacketBuffer".equals(transformedName)) {
            consumer = consumer.andThen(node -> StackUpTransformer.spliceClasses(node, "pl.asie.stackup.core.PacketBufferWriterSplice", "readItemStack", "func_150791_c", "writeItemStack", "func_150788_a"));
        } else if ("net.minecraft.client.renderer.RenderItem".equals(transformedName)) {
            consumer = consumer.andThen(RenderItemPatch::patchDrawItemCount);
        } else if ("net.minecraft.network.NetHandlerPlayServer".equals(transformedName)) {
            consumer = consumer.andThen(NetHandlerPlayServerPatch::patchCreativeInventory);
        } else if ("net.minecraftforge.common.util.PacketUtil".equals(transformedName)) {
            consumer = consumer.andThen(node -> StackUpTransformer.spliceClasses(node, "pl.asie.stackup.core.PacketUtilWriterSplice", "writeItemStackFromClientToServer"));
        } else if ("net.minecraft.item.ItemStack".equals(transformedName)) {
            consumer = consumer.andThen(ItemStackPatch::patchCountGetSet);
        }
        if (consumer != emptyConsumer) {
            return StackUpTransformer.processNode(basicClass, consumer);
        }
        return data;
    }

    public static byte[] processNode(byte[] data, Consumer<ClassNode> classNodeConsumer) {
        ClassReader reader = new ClassReader(data);
        ClassNode nodeOrig = new ClassNode();
        reader.accept((ClassVisitor)nodeOrig, 0);
        classNodeConsumer.accept(nodeOrig);
        ClassWriter writer = new ClassWriter(0);
        nodeOrig.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] spliceClasses(byte[] data, String className, String ... methods) {
        ClassReader reader = new ClassReader(data);
        ClassNode nodeOrig = new ClassNode();
        reader.accept((ClassVisitor)nodeOrig, 0);
        ClassNode nodeNew = StackUpTransformer.spliceClasses(nodeOrig, className, methods);
        ClassWriter writer = new ClassWriter(0);
        nodeNew.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode spliceClasses(ClassNode data, String className, String ... methods) {
        try (InputStream stream = StackUpCore.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");){
            ClassNode classNode = StackUpTransformer.spliceClasses(data, ByteStreams.toByteArray((InputStream)stream), className, methods);
            return classNode;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, String ... methods) {
        int j;
        boolean added;
        MethodNode mn;
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!methodSet.contains(s)) continue;
            nodeData.interfaces.add(s);
            System.out.println("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            mn = (MethodNode)nodeSplice.methods.get(i);
            added = false;
            for (j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                System.out.println("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                if (nodeData.superName != null && nodeData.name.equals(nodeSplice.superName)) {
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode) || node.getOpcode() != 183) continue;
                        MethodInsnNode methodNode = (MethodInsnNode)node;
                        if (!targetClassName2.equals(methodNode.owner)) continue;
                        methodNode.owner = nodeData.superName;
                    }
                }
                oldMn.name = (String)methodList.get(methodList.indexOf(oldMn.name) & 0xFFFFFFFE) + "_stackup_old";
                nodeData.methods.add(oldMn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added METHOD: " + targetClassName + "." + mn.name);
            nodeData.methods.add(mn);
            added = true;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            mn = (FieldNode)nodeSplice.fields.get(i);
            added = false;
            for (j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                System.out.println("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added FIELD: " + targetClassName + "." + mn.name);
            nodeData.fields.add(mn);
            added = true;
        }
        return nodeData;
    }
}

