/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElixirUtils {
    public static List<PotionEffect> deserializeEffects(NBTTagCompound tag) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (tag != null && tag.func_150297_b("ElixirEffects", 9)) {
            NBTTagList tagList = tag.func_150295_c("ElixirEffects", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound effectTag = tagList.func_150305_b(i);
                ResourceLocation effectName = new ResourceLocation(effectTag.func_74779_i("Effect"));
                int duration = effectTag.func_74762_e("Duration");
                int amplifier = effectTag.func_74762_e("Amplifier");
                if (ForgeRegistries.POTIONS == null || !ForgeRegistries.POTIONS.containsKey(effectName)) continue;
                effects.add(new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(effectName), duration, amplifier));
            }
        }
        return effects;
    }

    public static List<PotionEffect> getEffects(ItemStack stack) {
        if (stack.func_77942_o()) {
            return ElixirUtils.deserializeEffects(stack.func_77978_p());
        }
        return new ArrayList<PotionEffect>();
    }

    public static void addEffect(PotionEffect effect, ItemStack stack) {
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (!tag.func_150297_b("ElixirEffects", 9)) {
            NBTTagList tagList = new NBTTagList();
            tag.func_74782_a("ElixirEffects", (NBTBase)tagList);
        }
        NBTTagCompound effectTag = new NBTTagCompound();
        effectTag.func_74778_a("Effect", effect.func_188419_a().getRegistryName().toString());
        effectTag.func_74768_a("Duration", effect.func_76459_b());
        effectTag.func_74768_a("Amplifier", effect.func_76458_c());
        tag.func_150295_c("ElixirEffects", 10).func_74742_a((NBTBase)effectTag);
        stack.func_77982_d(tag);
    }

    public static int getColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b("ElixirEffects", 9) || tag.func_150295_c("ElixirEffects", 10).func_74745_c() <= 0) {
            return 0xF800F8;
        }
        ResourceLocation effectName = new ResourceLocation(tag.func_150295_c("ElixirEffects", 10).func_150305_b(0).func_74779_i("Effect"));
        if (ForgeRegistries.POTIONS != null && ForgeRegistries.POTIONS.containsKey(effectName)) {
            return ((Potion)ForgeRegistries.POTIONS.getValue(effectName)).func_76401_j();
        }
        return 0xF800F8;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(ItemStack itemIn, List<String> lores, float durationFactor) {
        List<PotionEffect> list = ElixirUtils.getEffects(itemIn);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.func_74838_a((String)"effect.none").trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)durationFactor) + ")";
                }
                if (potion.func_76398_f()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
        if (!list1.isEmpty()) {
            lores.add("");
            lores.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"potion.whenDrank"));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(TextFormatting.BLUE + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(TextFormatting.RED + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
            }
        }
    }
}

