/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.ICondenserRecipe;

public abstract class CondenserRecipe
implements ICondenserRecipe {
    ItemStack output;
    List<ItemStack> inputs;

    @Override
    public boolean matches(Fluid fluid, ItemStack modifier, ItemStack bottle, ItemStack[] inputs) {
        if (inputs.length <= 0) {
            return false;
        }
        if (this.inputs == null || this.inputs.size() <= 0) {
            return false;
        }
        if (bottle.func_77973_b() != Items.field_151069_bo) {
            return false;
        }
        if (fluid != FluidRegistry.WATER) {
            return false;
        }
        ArrayList<ItemStack> tempInputs = new ArrayList<ItemStack>(this.inputs);
        for (int i = 0; i < inputs.length; ++i) {
            ItemStack stack = inputs[i].func_77946_l();
            if (stack.func_190926_b()) continue;
            boolean stackNotInput = true;
            for (ItemStack temp : tempInputs) {
                if (!temp.func_77973_b().equals(stack.func_77973_b()) || temp.func_77960_j() != stack.func_77960_j()) continue;
                if (temp.func_77942_o() && stack.func_77942_o()) {
                    if (!temp.func_77978_p().equals((Object)stack.func_77978_p())) continue;
                    tempInputs.remove(stack);
                    stackNotInput = false;
                    break;
                }
                if (temp.func_77942_o()) continue;
                tempInputs.remove(temp);
                stackNotInput = false;
                break;
            }
            if (!stackNotInput) continue;
            return false;
        }
        return tempInputs.size() == 0;
    }

    @Override
    public FluidStack getFluid() {
        return new FluidStack(FluidRegistry.WATER, 125);
    }

    @Override
    public List<ItemStack> getBottles() {
        return Arrays.asList(new ItemStack(Items.field_151069_bo));
    }

    @Override
    public List<List<ItemStack>> getInputs() {
        ArrayList<List<ItemStack>> inputList = new ArrayList<List<ItemStack>>();
        for (ItemStack stack : this.inputs) {
            inputList.add(Arrays.asList(stack.func_77946_l()));
        }
        return inputList;
    }

    @Override
    public int[] getInputConsumption(ItemStack[] inputs) {
        return new int[]{1, 1, 1};
    }

    @Override
    public int getBottleConsumption(ItemStack bottle) {
        return 1;
    }

    @Override
    public int getModifierConsumption(ItemStack modifier) {
        return 1;
    }

    @Override
    public ItemStack getResult() {
        return this.output.func_77946_l();
    }
}

