/*
 * Decompiled with CFR 0.152.
 */
package com.rebirthofthenight.rotntweaker.tweaks.rotn;

import com.google.common.base.Optional;
import gloomyfolken.hooklib.api.Hook;
import gloomyfolken.hooklib.api.HookContainer;
import gloomyfolken.hooklib.api.LocalVariable;
import gloomyfolken.hooklib.api.OnBegin;
import gloomyfolken.hooklib.api.OnMethodCall;
import gloomyfolken.hooklib.api.OnReturn;
import gloomyfolken.hooklib.api.ReturnSolve;
import gloomyfolken.hooklib.api.Shift;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

@HookContainer
public class PrimalCoreImprovedConfig {
    private static Set<IBlockState> FIRE_SOURCE_BLOCKS;
    private static Set<IBlockState> HEAT_SOURCE_BLOCKS;

    private static Set<IBlockState> FIRE_SOURCE_BLOCKS() {
        if (FIRE_SOURCE_BLOCKS == null) {
            FIRE_SOURCE_BLOCKS = Arrays.stream(ModConfig.Flammability.FIRE_SOURCES).flatMap(PrimalCoreImprovedConfig::parseBlockState).collect(Collectors.toSet());
        }
        return FIRE_SOURCE_BLOCKS;
    }

    private static Set<IBlockState> HEAT_SOURCE_BLOCKS() {
        if (HEAT_SOURCE_BLOCKS == null) {
            HEAT_SOURCE_BLOCKS = Arrays.stream(ModConfig.Flammability.HEAT_SOURCE_BLOCKS).flatMap(PrimalCoreImprovedConfig::parseBlockState).collect(Collectors.toSet());
        }
        return HEAT_SOURCE_BLOCKS;
    }

    private static Stream<IBlockState> parseBlockState(String s) {
        int propStart = s.indexOf(91);
        Block block = Block.func_149684_b((String)(propStart > 0 ? s.substring(0, propStart) : s));
        if (block == null || block == Blocks.field_150350_a) {
            return Stream.of(new IBlockState[0]);
        }
        BlockStateContainer blockStateContainer = block.func_176194_O();
        if (propStart > 0) {
            IBlockState state = block.func_176223_P();
            for (String prop : s.substring(propStart + 1, s.length() - 1).split(",")) {
                int eq = prop.indexOf(58);
                String propName = prop.substring(0, eq);
                String propValue = prop.substring(eq + 1);
                IProperty property = blockStateContainer.func_185920_a(propName);
                if (property == null) continue;
                state = PrimalCoreImprovedConfig.setValueHelper(state, property, propValue);
            }
            return Stream.of(state);
        }
        return blockStateContainer.func_177619_a().stream();
    }

    private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState base, IProperty<T> property, String propValue) {
        Optional maybeValue = property.func_185929_b(propValue);
        if (maybeValue.isPresent()) {
            return base.func_177226_a(property, (Comparable)maybeValue.get());
        }
        return base;
    }

    @Hook
    @OnBegin
    public static ReturnSolve<Boolean> isFireSource(FireHelper fireHelper, IBlockAccess world, BlockPos pos, IBlockState state) {
        if (PrimalCoreImprovedConfig.FIRE_SOURCE_BLOCKS().contains(state)) {
            return ReturnSolve.yes((Object)true);
        }
        return ReturnSolve.no();
    }

    @Hook
    @OnMethodCall(value="getBlock")
    public static ReturnSolve<Boolean> hasNearByHeat(FireHelper fireHelper, World world, BlockPos pos, int horizontal, int vertical, boolean include_fire_sources, @LocalVariable(id=7) IBlockState check_state) {
        if (PrimalCoreImprovedConfig.HEAT_SOURCE_BLOCKS().contains(check_state)) {
            return ReturnSolve.yes((Object)true);
        }
        return ReturnSolve.no();
    }

    @Hook
    @OnMethodCall(value="getBlock")
    public static ReturnSolve<Boolean> hasDirectHeat(FireHelper fireHelper, World world, BlockPos pos, EnumFacing facing, @LocalVariable(id=4) IBlockState check_state) {
        if (PrimalCoreImprovedConfig.HEAT_SOURCE_BLOCKS().contains(check_state)) {
            return ReturnSolve.yes((Object)true);
        }
        return ReturnSolve.no();
    }

    @Hook
    @OnMethodCall(value="getBlockFromName", shift=Shift.INSTEAD)
    public static Block getBlockList(CommonUtils commonUtils, String[] array, @LocalVariable(id=6) String name) {
        int propStart = name.indexOf(91);
        return Block.func_149684_b((String)(propStart > 0 ? name.substring(0, propStart) : name));
    }

    @Hook
    @OnReturn
    public static void postInit(BlockHelper blockHelper) {
        FireHelper.FIRE_SOURCE_BLOCKS.clear();
        FireHelper.HEAT_SOURCE_BLOCKS.clear();
    }
}

