/*
 * Decompiled with CFR 0.152.
 */
package com.rebirthofthenight.rotntweaker.tweaks.rotn;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalBellowsTop;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalCompactingBinWorker;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalMulchSpreader;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileTripHammer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileLense;
import com.google.common.base.Suppliers;
import gloomyfolken.hooklib.api.FieldAccessor;
import gloomyfolken.hooklib.api.FieldLens;
import gloomyfolken.hooklib.api.Hook;
import gloomyfolken.hooklib.api.HookContainer;
import gloomyfolken.hooklib.api.OnMethodCall;
import gloomyfolken.hooklib.api.Shift;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HookContainer
public class BWM2Pyrotech {
    private static Supplier<ItemStack> fakeCog = Suppliers.memoize(() -> new ItemStack((Item)ModuleTechMachine.Items.IRON_COG));
    @FieldLens(createField=true)
    public static FieldAccessor<TileCogWorkerBase, CustomTickCounter> updateTickCounter2;
    @FieldLens
    public static FieldAccessor<TileCogWorkerBase, TileDataBoolean> triggered;

    @SubscribeEvent
    public void attachCapa(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileCogWorkerBase) {
            TileCogWorkerBase tile = (TileCogWorkerBase)event.getObject();
            event.addCapability(new ResourceLocation("rotntweaker", "bwm_power"), (ICapabilityProvider)new MechanicalPowerProvider(tile, tile instanceof TileMechanicalMulchSpreader ? 2 : 1));
        }
    }

    @Hook(targetMethod="doWork")
    @OnMethodCall(value="getCog", shift=Shift.INSTEAD)
    public static ItemStack useFakeCog(TileMechanicalCompactingBinWorker tile, ItemStack cog) {
        return fakeCog.get();
    }

    @Hook
    @OnMethodCall(value="getStackInSlot")
    public static void update(TileCogWorkerBase tile) {
        boolean ready;
        if (TileLense.isPowered(tile)) {
            return;
        }
        IMechanicalPower capa = (IMechanicalPower)tile.getCapability(CapabilityMechanicalPower.MECHANICAL_POWER, null);
        if (capa == null) {
            return;
        }
        EnumFacing facing = BWM2Pyrotech.getCogSide(tile);
        int mechanicalInput = capa.getMechanicalInput(facing);
        if (mechanicalInput < capa.getMinimumInput(facing)) {
            return;
        }
        CustomTickCounter tickCounter = (CustomTickCounter)updateTickCounter2.get((Object)tile);
        boolean bl = ready = tickCounter != null && tickCounter.increment(mechanicalInput);
        if (ready) {
            tickCounter.reset();
            int cogDamage = TileLense.doWork(tile, fakeCog.get());
            if (cogDamage >= 0) {
                ((TileDataBoolean)triggered.get((Object)tile)).set(true);
                return;
            }
        }
        ((TileDataBoolean)triggered.get((Object)tile)).set(false);
    }

    private static EnumFacing getCogSide(TileCogWorkerBase tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        EnumFacing tileFacing = tile.getTileFacing(world, pos, world.func_180495_p(pos));
        if (tile instanceof TileMechanicalMulchSpreader) {
            return tileFacing.func_176734_d();
        }
        if (tile instanceof TileMechanicalBellowsTop) {
            return tileFacing.func_176734_d();
        }
        if (tile instanceof TileMechanicalCompactingBinWorker) {
            return tileFacing.func_176746_e();
        }
        if (tile instanceof TileTripHammer) {
            return tileFacing.func_176735_f();
        }
        return tileFacing;
    }

    public static class CustomTickCounter {
        private final int woodMax;
        private final int steelMax;
        private int count;

        public CustomTickCounter(int woodMax, int steelMax) {
            this.woodMax = woodMax;
            this.steelMax = steelMax;
        }

        public void reset() {
            this.count = 0;
        }

        public boolean increment(int power) {
            boolean isWoodPowered = power <= 2;
            ++this.count;
            if (this.count >= (isWoodPowered ? this.woodMax : this.steelMax)) {
                this.reset();
                return true;
            }
            return false;
        }
    }

    public static class MechanicalPowerProvider
    implements ICapabilityProvider,
    IMechanicalPower {
        private final TileCogWorkerBase tile;
        private final int checkDistance;

        public MechanicalPowerProvider(TileCogWorkerBase tile, int checkDistance) {
            this.tile = tile;
            this.checkDistance = checkDistance;
        }

        public int getMechanicalOutput(EnumFacing facing) {
            return -1;
        }

        public int getMechanicalInput(EnumFacing facing) {
            World world = this.tile.func_145831_w();
            BlockPos pos = this.tile.func_174877_v();
            if (facing == BWM2Pyrotech.getCogSide(this.tile)) {
                return BWMAPI.IMPLEMENTATION.getPowerOutput(world, pos.func_177967_a(facing, this.checkDistance), facing.func_176734_d());
            }
            return 0;
        }

        public int getMaximumInput(EnumFacing facing) {
            return 1;
        }

        public int getMinimumInput(EnumFacing facing) {
            return 1;
        }

        public Block getBlock() {
            return this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v()).func_177230_c();
        }

        public World getBlockWorld() {
            return this.tile.func_145831_w();
        }

        public BlockPos getBlockPos() {
            return this.tile.func_174877_v();
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityMechanicalPower.MECHANICAL_POWER;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
            }
            return null;
        }
    }
}

