/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.minecraft_enhanced_snowman;

import de.maxanier.minecraft_enhanced_snowman.Configs;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="enhanced_snowman", name="EnhancedSnowman", version="1.0", acceptedMinecraftVersions="[1.12.0,1.13)")
public class ModEnhancedSnowman {
    public static final String MOD_ID = "enhanced_snowman";
    public static final String MOD_NAME = "EnhancedSnowman";
    public static final String VERSION = "1.0";
    @Mod.Instance(value="enhanced_snowman")
    public static ModEnhancedSnowman INSTANCE;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void onLivingBaseAttack(LivingAttackEvent event) {
        if (event.getAmount() == 0.0f && event.getSource().func_76364_f() instanceof EntitySnowball) {
            EntitySnowball ball;
            if (event.getEntityLiving().func_130014_f_().field_72995_K) {
                return;
            }
            if ((event.getSource().func_76346_g() instanceof EntitySnowman || Configs.playersDealDamage && event.getSource().func_76346_g() instanceof EntityPlayer) && (event.getEntityLiving() instanceof IMob || !Configs.onlyHostile) && !(ball = (EntitySnowball)event.getSource().func_76364_f()).getEntityData().func_74764_b("dealt_damage")) {
                ball.getEntityData().func_74757_a("dealt_damage", true);
                event.getEntityLiving().func_70097_a((DamageSource)new EntityDamageSourceIndirect("thrown", event.getSource().func_76364_f(), event.getSource().func_76346_g()), Configs.snowballDamage);
                if (Configs.slowness) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 1));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (Configs.convert && event.getSource().func_76346_g() instanceof EntitySnowman && Configs.convert_chance > Math.random()) {
            EntitySnowman snowman = new EntitySnowman(event.getEntityLiving().func_130014_f_());
            snowman.func_82149_j((Entity)event.getEntityLiving());
            event.getEntityLiving().func_130014_f_().func_72838_d((Entity)snowman);
        }
    }
}

