/*
 * Decompiled with CFR 0.152.
 */
package dev.lonami.logimmune;

import dev.lonami.logimmune.BuffMessage;
import dev.lonami.logimmune.BuffMessageHandler;
import dev.lonami.logimmune.Buffs;
import dev.lonami.logimmune.PacketHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="logimmune", name="Log Immune", version="0.1", acceptedMinecraftVersions="[1.12.2]")
public class LogImmune {
    public static final String MODID = "logimmune";
    public static final String NAME = "Log Immune";
    public static final String VERSION = "0.1";
    public static Logger logger;
    public static boolean isBuffed;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        isBuffed = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.INSTANCE.registerMessage(BuffMessageHandler.class, BuffMessage.class, 0, Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(BuffMessageHandler.class, BuffMessage.class, 0, Side.SERVER);
        logger.info("Successfully initialized");
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.buffPlayer(event.player);
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.buffPlayer(event.player);
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.buffPlayer(event.player);
    }

    private void buffPlayer(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            Buffs.buff((EntityLivingBase)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new BuffMessage(true), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMoved(InputUpdateEvent event) {
        if (!isBuffed) {
            return;
        }
        MovementInput mi = event.getMovementInput();
        if (mi.field_187255_c || mi.field_187256_d || mi.field_187257_e || mi.field_187258_f) {
            isBuffed = false;
            PacketHandler.INSTANCE.sendToServer((IMessage)new BuffMessage(false));
        }
    }
}

