/*
 * Decompiled with CFR 0.152.
 */
package netherchest.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ExtendedItemStackHandler
extends ItemStackHandler {
    public ExtendedItemStackHandler() {
        this(1);
    }

    public ExtendedItemStackHandler(int size) {
        super(size);
    }

    public ExtendedItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public int getSlotLimit(int slot) {
        return 512;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d() * 8);
    }

    public void onContentsChanged(int slot) {
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            short realCount = (short)Math.min(Short.MAX_VALUE, ((ItemStack)this.stacks.get(i)).func_190916_E());
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            itemTag.func_74777_a("ExtendedCount", realCount);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.func_150297_b("StackList", 9)) {
                stack = ItemStack.field_190927_a;
                NBTTagList stackTagList = itemTags.func_150295_c("StackList", 10);
                for (int j = 0; j < stackTagList.func_74745_c(); ++j) {
                    NBTTagCompound itemTag = stackTagList.func_150305_b(j);
                    ItemStack temp = new ItemStack(itemTag);
                    if (temp.func_190926_b()) continue;
                    if (stack.func_190926_b()) {
                        stack = temp;
                        continue;
                    }
                    stack.func_190917_f(temp.func_190916_E());
                }
                if (stack.func_190926_b()) continue;
                int count = stack.func_190916_E();
                count = Math.min(count, this.getStackLimit(slot, stack));
                stack.func_190920_e(count);
                this.stacks.set(slot, (Object)stack);
                continue;
            }
            stack = new ItemStack(itemTags);
            if (itemTags.func_150297_b("ExtendedCount", 2)) {
                stack.func_190920_e((int)itemTags.func_74765_d("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            f += (float)stack.func_190916_E() / (float)this.getStackLimit(slot, stack);
            ++numStacks;
        }
        return MathHelper.func_76141_d((float)((f /= (float)this.getSlots()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }
}

