/*
 * Decompiled with CFR 0.152.
 */
package netherchest.client.renderers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import netherchest.common.tileentity.TileEntityNetherChest;
import org.lwjgl.opengl.GL11;

public class TileEntityNetherChestRenderer
extends TileEntitySpecialRenderer<TileEntityNetherChest> {
    public static TextureAtlasSprite portalSprite = null;
    private static final ResourceLocation TEXTURE = new ResourceLocation("netherchest:textures/model/nether_chest.png");
    private final ModelChest model = new ModelChest();
    private final Random rand = new Random();

    public void render(TileEntityNetherChest te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int i;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (te.func_145830_o()) {
            Block block = te.func_145838_q();
            i = te.func_145832_p();
        } else {
            i = 0;
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(TEXTURE);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        int j = 0;
        if (i == 2) {
            j = 180;
        }
        if (i == 3) {
            j = 0;
        }
        if (i == 4) {
            j = 90;
        }
        if (i == 5) {
            j = -90;
        }
        GlStateManager.func_179114_b((float)j, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f = te.prevLidAngle + (te.lidAngle - te.prevLidAngle) * partialTicks;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        this.model.field_78234_a.field_78795_f = -(f * 1.5707964f);
        this.model.func_78231_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (te.lidAngle > 0.01f) {
            this.renderPortal(x, y, z, partialTicks, te.getRenderTick(), 1.0f);
        }
    }

    private void renderPortal(double x, double y, double z, float partialTicks, int renderTick, float lidAngle) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int dfunc = GL11.glGetInteger((int)2932);
        GlStateManager.func_179143_c((int)515);
        int func = GL11.glGetInteger((int)3009);
        float ref = GL11.glGetFloat((int)3010);
        GlStateManager.func_179092_a((int)519, (float)0.0f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (portalSprite != null) {
            this.func_147499_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            int q = 12;
            for (int pZ = 0; pZ < q; ++pZ) {
                for (int pX = 0; pX < q; ++pX) {
                    double minX = 0.25 + (double)pX * (1.0 / (double)q * 0.5);
                    double maxX = minX + 1.0 / (double)q * 0.5;
                    double minZ = 0.25 + (double)pZ * (1.0 / (double)q * 0.5);
                    double maxZ = minZ + 1.0 / (double)q * 0.5;
                    double dU = portalSprite.func_94212_f() - portalSprite.func_94209_e();
                    double dV = portalSprite.func_94210_h() - portalSprite.func_94206_g();
                    double minU = (double)portalSprite.func_94209_e() + dU * ((double)pX * (1.0 / (double)q));
                    double maxU = (double)portalSprite.func_94209_e() + dU * ((double)(pX + 1) * (1.0 / (double)q));
                    double minV = (double)portalSprite.func_94206_g() + dV * ((double)pZ * (1.0 / (double)q));
                    double maxV = (double)portalSprite.func_94206_g() + dV * ((double)(pZ + 1) * (1.0 / (double)q));
                    double y1 = 0.6251 + this.yOffset(pX, pZ, partialTicks, renderTick) * (double)lidAngle;
                    double y2 = 0.6251 + this.yOffset(pX, pZ + 1, partialTicks, renderTick) * (double)lidAngle;
                    double y3 = 0.6251 + this.yOffset(pX + 1, pZ + 1, partialTicks, renderTick) * (double)lidAngle;
                    double y4 = 0.6251 + this.yOffset(pX + 1, pZ, partialTicks, renderTick) * (double)lidAngle;
                    buffer.func_181662_b(minX, y1, minZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a(minU, minV).func_187314_a(240, 240).func_181675_d();
                    buffer.func_181662_b(minX, y2, maxZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a(minU, maxV).func_187314_a(240, 240).func_181675_d();
                    buffer.func_181662_b(maxX, y3, maxZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a(maxU, maxV).func_187314_a(240, 240).func_181675_d();
                    buffer.func_181662_b(maxX, y4, minZ).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a(maxU, minV).func_187314_a(240, 240).func_181675_d();
                }
            }
            tess.func_78381_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179092_a((int)func, (float)ref);
        GlStateManager.func_179143_c((int)dfunc);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179099_b();
    }

    private double yOffset(int x, int z, float partialTicks, int renderTick) {
        double xScale = (double)(-Math.abs(x - 6) + 6) * 0.125;
        double zScale = (double)(-Math.abs(z - 6) + 6) * 0.125;
        if (xScale == 0.0 || zScale == 0.0) {
            return 0.0;
        }
        double scale = (zScale + xScale) / 2.0;
        int offset = x * 4673 % 19 * (z * 3491 % 23) % 341 + x * 4327 % 26;
        double amp = scale * 0.0625;
        return amp + amp * (double)MathHelper.func_76126_a((float)((float)(renderTick - offset) * 0.05f));
    }

    private void renderOpenEffects(double x, double y, double z, float angle) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179090_x();
        int dfunc = GL11.glGetInteger((int)2932);
        GlStateManager.func_179143_c((int)515);
        int func = GL11.glGetInteger((int)3009);
        float ref = GL11.glGetFloat((int)3010);
        GlStateManager.func_179092_a((int)519, (float)0.0f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.renderLightRay(angle);
        GlStateManager.func_179121_F();
        GlStateManager.func_179092_a((int)func, (float)ref);
        GlStateManager.func_179143_c((int)dfunc);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179099_b();
    }

    private void renderLightRay(float angle) {
        int red = 150;
        int green = 0;
        int blue = 100;
        int alpha = (int)(128.0 * Math.sqrt(angle));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        for (int i = 0; i < 4; ++i) {
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            double minXZ = 0.25 + 0.0625 * (double)i;
            double maxXZ = 1.0 - minXZ;
            double deltaXZ = 0.125;
            double minY = 0.625;
            double maxY = minY + 0.375 - 0.0625 * (double)i;
            buffer.func_181662_b((minXZ + maxXZ) / 2.0, maxY, (minXZ + maxXZ) / 2.0).func_181669_b(red, green, blue, 0).func_181675_d();
            buffer.func_181662_b(minXZ, minY, minXZ).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(minXZ, minY, maxXZ).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(maxXZ, minY, maxXZ).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(maxXZ, minY, minXZ).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(minXZ, minY, minXZ).func_181669_b(red, green, blue, alpha).func_181675_d();
            tess.func_78381_a();
        }
    }
}

