/*
 * Decompiled with CFR 0.152.
 */
package alsender.earthworks.block;

import alsender.earthworks.main.Earthworks;
import alsender.earthworks.main.registry.BlockRegistry;
import alsender.earthworks.main.registry.ItemRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Block_ChalkDust
extends Block {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.func_177709_a((String)"north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.func_177709_a((String)"east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.func_177709_a((String)"west", EnumAttachPosition.class);
    protected static final AxisAlignedBB[] CHALK_DUST_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public Block_ChalkDust() {
        super(Material.field_151569_G);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149711_c(0.1f);
        this.func_149752_b(0.0f);
        this.func_149663_c("earthworks.block_chalk_dust");
        this.setRegistryName("block_chalk_dust");
        this.func_149647_a(Earthworks.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(NORTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumAttachPosition.NONE)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHALK_DUST_AABB[Block_ChalkDust.getAABBIndex(state.func_185899_b(source, pos))];
    }

    private static int getAABBIndex(IBlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b(NORTH) != EnumAttachPosition.NONE;
        boolean flag1 = state.func_177229_b(EAST) != EnumAttachPosition.NONE;
        boolean flag2 = state.func_177229_b(SOUTH) != EnumAttachPosition.NONE;
        boolean bl = flag3 = state.func_177229_b(WEST) != EnumAttachPosition.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.SOUTH)));
        return state;
    }

    private EnumAttachPosition getAttachPosition(IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (!(Block_ChalkDust.canConnectTo(worldIn.func_180495_p(blockpos), direction, worldIn, blockpos) || !iblockstate.func_185915_l() && Block_ChalkDust.canConnectUpwardsTo(worldIn, blockpos.func_177977_b()))) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177984_a());
            if (!iblockstate1.func_185915_l()) {
                boolean flag;
                boolean bl = flag = worldIn.func_180495_p(blockpos).isSideSolid(worldIn, blockpos, EnumFacing.UP) || worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150426_aN;
                if (flag && Block_ChalkDust.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
                    if (iblockstate.func_185898_k()) {
                        return EnumAttachPosition.UP;
                    }
                    return EnumAttachPosition.SIDE;
                }
            }
            return EnumAttachPosition.NONE;
        }
        return EnumAttachPosition.SIDE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN;
    }

    private IBlockState updateSurroundingChalk(World worldIn, BlockPos pos, IBlockState state) {
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_175685_c(blockpos, (Block)this, false);
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingChalk(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            this.updateSurroundingChalk(worldIn, pos, state);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingChalk(worldIn, pos, state);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.item_chalk;
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return Block_ChalkDust.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block == BlockRegistry.block_chalk_dust;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ItemRegistry.item_chalk);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(SOUTH, state.func_177229_b(NORTH)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(EAST)).func_177226_a(EAST, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(WEST)).func_177226_a(EAST, state.func_177229_b(NORTH)).func_177226_a(SOUTH, state.func_177229_b(EAST)).func_177226_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    static enum EnumAttachPosition implements IStringSerializable
    {
        UP("up"),
        SIDE("side"),
        NONE("none");

        private final String name;

        private EnumAttachPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

