/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilEntity;
import com.corosus.zombie_players.config.ConfigZombiePlayers;
import com.corosus.zombie_players.entity.EntityZombiePlayer;
import com.corosus.zombie_players.util.UtilScanner;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class EntityAIInteractChest
extends EntityAIBase {
    protected final EntityZombiePlayer entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;
    public int ticksChestOpen = 0;
    public int ticksChestOpenMax = 10;

    public EntityAIInteractChest(EntityZombiePlayer creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!ConfigZombiePlayers.messUpChests || this.entity instanceof EntityZombiePlayer && !this.entity.spawnedFromPlayerDeath) {
            return false;
        }
        if (this.entity instanceof EntityZombiePlayer && this.entity.getCalmTime() > 0) {
            return false;
        }
        if (!this.mustUpdate && this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        BlockPos pos = UtilScanner.findBlock((EntityLiving)this.entity, 16, 1, 10, UtilScanner::isChest);
        if (pos != null && CoroUtilEntity.canCoordBeSeen((EntityLivingBase)this.entity, (int)pos.func_177958_n(), (int)(pos.func_177956_o() + 1), (int)pos.func_177952_p())) {
            CULog.dbg((String)"found visible chest coord, pathing");
            return new Vec3d((Vec3i)pos);
        }
        return null;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() || this.ticksChestOpen < this.ticksChestOpenMax;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
    }

    public void func_75246_d() {
        super.func_75246_d();
        double dist = this.entity.func_70011_f(this.x + 0.5, this.y + 0.5, this.z + 0.5);
        if (dist < 2.5) {
            this.entity.func_70661_as().func_75499_g();
            if (this.ticksChestOpen == 0) {
                this.shuffleSingleItemStack(new BlockPos(this.x, this.y, this.z));
            }
            if (this.ticksChestOpen < this.ticksChestOpenMax) {
                ++this.ticksChestOpen;
            }
        }
    }

    public void shuffleSingleItemStack(BlockPos pos) {
        TileEntity tEnt = this.entity.field_70170_p.func_175625_s(pos);
        if (tEnt instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tEnt;
            int randSlot1 = 0;
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                if (chest.func_70301_a(i) == ItemStack.field_190927_a) continue;
                randSlot1 = i;
                break;
            }
            int randSlot2 = this.entity.field_70170_p.field_73012_v.nextInt(chest.func_70302_i_());
            ItemStack stack1 = chest.func_70301_a(randSlot1);
            ItemStack stack2 = chest.func_70301_a(randSlot2);
            chest.func_70299_a(randSlot1, stack2);
            chest.func_70299_a(randSlot2, stack1);
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
            if (!this.entity.hasOpenedChest) {
                this.entity.openChest(new BlockPos(this.x, this.y, this.z));
            }
            CULog.dbg((String)"EntityAIInteractChest swapped item contents");
        } else {
            this.func_75251_c();
        }
    }

    public void func_75251_c() {
        CULog.dbg((String)"reset task");
        this.entity.func_70661_as().func_75499_g();
        this.ticksChestOpen = 0;
        super.func_75251_c();
    }
}

