/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.zombie_players.entity.EntityZombiePlayer;
import java.util.Iterator;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class EntityAIEatToHeal
extends EntityAIBase {
    private final EntityZombiePlayer entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private float missingHealthToHeal = 5.0f;
    public BlockPos posCachedBestChest = null;

    public EntityAIEatToHeal(EntityZombiePlayer entityObjIn) {
        this.entityObj = entityObjIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.entityObj.isFoodNeedUrgent()) {
            this.posCachedBestChest = this.getClosestChestPosWithFood();
            return this.posCachedBestChest != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.entityObj.isFoodNeedUrgent() && this.verifyOrGetNewChest();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.posCachedBestChest != null) {
            boolean isClose = false;
            BlockPos blockposGoal = this.posCachedBestChest;
            if (blockposGoal == null) {
                this.func_75251_c();
                return;
            }
            double dist = this.entityObj.func_174791_d().func_72438_d(new Vec3d((double)blockposGoal.func_177958_n(), (double)blockposGoal.func_177956_o(), (double)blockposGoal.func_177952_p()));
            if (dist <= 3.0) {
                this.entityObj.openChest(this.posCachedBestChest);
                this.consumeOneStackSizeOfFoodAtChest();
                this.entityObj.ateCalmingItem(true);
                this.entityObj.func_70661_as().func_75499_g();
                return;
            }
            if (!isClose) {
                if ((this.entityObj.func_70661_as().func_75500_f() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.func_177958_n();
                    int j = blockposGoal.func_177956_o();
                    int k = blockposGoal.func_177952_p();
                    boolean success = false;
                    if (this.entityObj.func_174818_b(blockposGoal) > 256.0) {
                        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.entityObj, (int)14, (int)3, (Vec3d)new Vec3d((double)i + 0.5, (double)j, (double)k + 0.5));
                        if (vec3d != null) {
                            success = this.entityObj.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.3);
                        }
                    } else {
                        success = this.entityObj.func_70661_as().func_75492_a((double)i + 0.5, (double)j, (double)k + 0.5, 1.3);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entityObj.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.walkingTimeout = 0;
    }

    public BlockPos getClosestChestPosWithFood() {
        Iterator<BlockPos> it = this.entityObj.listPosChests.iterator();
        double closestDist = Double.MAX_VALUE;
        BlockPos closestPos = null;
        while (it.hasNext()) {
            double dist;
            BlockPos pos = it.next();
            if (!this.entityObj.isValidChest(pos, false) || !((dist = this.entityObj.func_180425_c().func_177951_i((Vec3i)pos)) < closestDist)) continue;
            closestDist = dist;
            closestPos = pos;
        }
        return closestPos;
    }

    public ItemStack consumeOneStackSizeOfFoodAtChest() {
        TileEntity tile;
        if (this.posCachedBestChest != null && (tile = this.entityObj.field_70170_p.func_175625_s(this.posCachedBestChest)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return this.consumeOneStackSizeOfFood((IInventory)chest);
        }
        return null;
    }

    public ItemStack consumeOneStackSizeOfFood(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_190916_E() <= 0 || !this.entityObj.isRawMeat(stack)) continue;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            return new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
        }
        return null;
    }

    public boolean verifyOrGetNewChest() {
        if (this.posCachedBestChest == null) {
            return false;
        }
        if (!this.entityObj.isValidChest(this.posCachedBestChest, false)) {
            this.posCachedBestChest = this.getClosestChestPosWithFood();
        }
        return this.posCachedBestChest != null;
    }
}

