/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.Miscellaneous.DebugBlock;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class BlockDebug
extends Block {
    public BlockDebug(String name, CreativeTabs tab) {
        super(Material.field_151576_e);
        Registry.PATCH.setRegistryName((Object)this, name);
        this.func_149647_a(tab);
        this.func_149663_c(name);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.showDebugInfo(worldIn, pos.func_177977_b());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.showDebugInfo(worldIn, pos.func_177977_b());
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.showDebugInfo(worldIn, pos.func_177977_b());
    }

    public void showDebugInfo(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            NBTTagCompound tag;
            String text = "\n     Block \"" + state.func_177230_c().getRegistryName() + "\" at " + pos.toString() + "\n          with blockstate {" + state.toString() + "}";
            if (state.func_177230_c().hasTileEntity(state)) {
                TileEntity tileEntity = world.func_175625_s(pos);
                text = tileEntity != null ? text + "\n          and with tileentity {" + tileEntity.func_189515_b(new NBTTagCompound()).toString() + "}" : text + "\n          and with tileentity {null}";
            }
            if (ModulePistons.isEnabled && (tag = TileEntityHelper.get_tileEntity(world, pos)) != null) {
                text = text + "\n          TileEntityHelper Data {" + tag.toString() + "}";
            }
            System.out.println(text);
        }
    }
}

