/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityMessage;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileMapData;

public class TileEntityHelper {
    private static Map mapServer = new HashMap();
    private static Map mapClient = new HashMap();
    private static Map<String, TileMapData> chestMap = new HashMap<String, TileMapData>();
    private static Map<String, Integer> lightMap = new HashMap<String, Integer>();
    private static ArrayList<String> clearTagList = new ArrayList();
    private static List<AirData> airListClient = new ArrayList<AirData>();
    private static List<AirData> airListServer = new ArrayList<AirData>();
    private static ArrayList<UpdateData> delayedUpdateListClient = new ArrayList();
    private static ArrayList<UpdateData> delayedUpdateListServer = new ArrayList();

    private static String key(int dimension, BlockPos pos) {
        return pos.toString() + "@d=" + dimension;
    }

    public static void setBlockToAir(World world, BlockPos pos) {
        if (world.field_72995_K) {
            airListClient.add(new AirData(world, pos));
        } else {
            airListServer.add(new AirData(world, pos));
        }
    }

    public static void unlistToAir(World world, BlockPos pos) {
        AirData air;
        int i;
        for (i = 0; i < airListClient.size(); ++i) {
            air = airListClient.get(i);
            if (!air.equals(world, pos)) continue;
            airListClient.remove(i);
        }
        for (i = 0; i < airListServer.size(); ++i) {
            air = airListServer.get(i);
            if (!air.equals(world, pos)) continue;
            airListServer.remove(i);
        }
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state) {
        TileEntityHelper.setBlockState(world, pos, state, false);
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state, boolean forceDelay) {
        if (forceDelay || state.func_177230_c().hasTileEntity(state)) {
            TileEntityHelper.scheduleDelayedUpdate(world, pos, state);
        } else {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                world.func_175713_t(pos);
                tileEntity.func_145843_s();
            }
            world.func_180501_a(pos, state, 3);
            world.func_190524_a(pos, state.func_177230_c(), pos);
            IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
            movable.postMove(world, state, null, null, pos);
        }
    }

    public static TileEntity setBlockStateWithTileEntity(World world, BlockPos pos, IBlockState state, int flags) {
        IBlockState preState = world.func_180495_p(pos);
        world.func_180501_a(pos, state, 0);
        NBTTagCompound compound = TileEntityHelper.get_tileEntity(world, pos);
        TileEntity tileEntity = null;
        if (compound != null && (tileEntity = world.func_175625_s(pos)) != null) {
            tileEntity.func_145839_a(compound);
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), preState, state, flags);
        return tileEntity;
    }

    public static void add_tileEntity(World world, BlockPos pos, NBTTagCompound tag) {
        if (!world.field_72995_K) {
            TileEntityHelper.add_tileEntity(world.field_73011_w.getDimension(), pos, tag, false);
            Registry.NETWORK.sendToAllClients(new TileEntityMessage(tag, world.field_73011_w.getDimension()));
        }
    }

    public static void add_tileEntity(int dimension, BlockPos pos, NBTTagCompound tag, boolean isClient) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        String key = TileEntityHelper.key(dimension, pos);
        if (isClient) {
            if (mapClient.containsKey(key)) {
                TileEntityHelper.remove_tileEntity(dimension, pos, true);
            }
            mapClient.put(key, tag);
        } else {
            if (mapServer.containsKey(key)) {
                TileEntityHelper.remove_tileEntity(dimension, pos, false);
            }
            mapServer.put(key, tag);
        }
    }

    public static void add_tileEntity(World world, BlockPos pos, TileEntity tileEntity) {
        NBTTagCompound ret = new NBTTagCompound();
        NBTTagCompound tag = tileEntity.func_189515_b(ret);
        TileEntityHelper.add_tileEntity(world, pos, tag);
    }

    public static void remove_tileEntity(World world, BlockPos pos) {
        TileEntityHelper.remove_tileEntity(world.field_73011_w.getDimension(), pos, world.field_72995_K);
    }

    public static void remove_tileEntity(int dimension, BlockPos pos, boolean isClient) {
        if (isClient) {
            mapClient.remove(TileEntityHelper.key(dimension, pos));
        } else {
            mapServer.remove(TileEntityHelper.key(dimension, pos));
        }
    }

    public static NBTTagCompound get_tileEntity(World world, BlockPos pos) {
        return TileEntityHelper.get_tileEntity(world.field_73011_w.getDimension(), pos, world.field_72995_K);
    }

    public static NBTTagCompound get_tileEntity(int dimension, BlockPos pos, boolean isClient) {
        String key = TileEntityHelper.key(dimension, pos);
        if (isClient) {
            return (NBTTagCompound)mapClient.get(key);
        }
        return (NBTTagCompound)mapServer.get(key);
    }

    public static void registerClearTag(String tag) {
        clearTagList.add(tag);
    }

    public static NBTTagCompound get_emptyTileEntity(NBTTagCompound tag) {
        NBTTagCompound copy = tag.func_74737_b();
        for (int i = 0; i < clearTagList.size(); ++i) {
            String key = clearTagList.get(i);
            TileEntityHelper.clearNBTTag(copy, key);
        }
        return copy;
    }

    public static void clearNBTTag(NBTTagCompound compound, String key) {
        if (compound.func_74764_b(key)) {
            NBTBase tag = compound.func_74781_a(key);
            if (tag instanceof NBTTagList) {
                compound.func_74782_a(key, (NBTBase)new NBTTagList());
            } else if (tag instanceof NBTTagCompound) {
                compound.func_74782_a(key, (NBTBase)new NBTTagCompound());
            } else if (tag instanceof NBTTagByte) {
                compound.func_74774_a(key, (byte)0);
            } else if (tag instanceof NBTTagShort) {
                compound.func_74777_a(key, (short)0);
            } else if (tag instanceof NBTTagInt) {
                compound.func_74768_a(key, 0);
            } else if (tag instanceof NBTTagLong) {
                compound.func_74772_a(key, 0L);
            } else if (tag instanceof NBTTagFloat) {
                compound.func_74776_a(key, 0.0f);
            } else if (tag instanceof NBTTagDouble) {
                compound.func_74780_a(key, 0.0);
            } else if (tag instanceof NBTTagString) {
                compound.func_74778_a(key, "");
            } else if (tag instanceof NBTTagByteArray) {
                compound.func_74773_a(key, new byte[0]);
            } else if (tag instanceof NBTTagIntArray) {
                compound.func_74783_a(key, new int[0]);
            } else {
                compound.func_82580_o(key);
            }
        }
    }

    public static void scheduleDelayedUpdate(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            delayedUpdateListClient.add(new UpdateData(world, pos, state));
        } else {
            delayedUpdateListServer.add(new UpdateData(world, pos, state));
        }
    }

    public static void callDelayedUpdates() {
        int i;
        for (i = 0; i < delayedUpdateListServer.size(); ++i) {
            delayedUpdateListServer.get(i).setBlockState();
        }
        for (i = 0; i < delayedUpdateListClient.size(); ++i) {
            delayedUpdateListClient.get(i).setBlockState();
        }
        for (i = 0; i < airListClient.size(); ++i) {
            airListClient.get(i).setToAir();
        }
        for (i = 0; i < airListServer.size(); ++i) {
            airListServer.get(i).setToAir();
        }
        for (i = 0; i < delayedUpdateListServer.size(); ++i) {
            delayedUpdateListServer.get(i).update();
        }
        for (i = 0; i < delayedUpdateListClient.size(); ++i) {
            delayedUpdateListClient.get(i).update();
        }
        delayedUpdateListClient.clear();
        delayedUpdateListServer.clear();
        airListClient.clear();
        airListServer.clear();
    }

    public static void add_chest(World world, BlockPos pos, EnumFacing movingDir) {
        String key = TileEntityHelper.key(world.field_73011_w.getDimension(), pos);
        if (!chestMap.containsKey(key)) {
            chestMap.put(key, new TileMapData(TileEntityHelper.getChestType(world, pos), movingDir));
        }
    }

    public static int get_chest(World world, BlockPos pos) {
        String key = TileEntityHelper.key(world.field_73011_w.getDimension(), pos);
        if (chestMap.containsKey(key)) {
            return TileEntityHelper.chestMap.get((Object)key).type;
        }
        return -1;
    }

    public static void remove_chest(World world, BlockPos pos) {
        String key = TileEntityHelper.key(world.field_73011_w.getDimension(), pos);
        while (chestMap.containsKey(key)) {
            chestMap.remove(key);
        }
    }

    public static void remove_chestList(World world, ArrayList<BlockPos> chestList, EnumFacing moveDirection) {
        for (int i = 0; i < chestList.size(); ++i) {
            TileEntityHelper.remove_chest(world, chestList.get(i).func_177972_a(moveDirection));
        }
    }

    public static boolean canMoveChests(World world, IBlockState chest, EnumFacing moveDirection, ArrayList<BlockPos> chestList) {
        for (int i = 0; i < chestList.size(); ++i) {
            if (TileEntityHelper.canMoveChest(world, chestList.get(i), chest, moveDirection, chestList)) continue;
            return false;
        }
        return true;
    }

    public static boolean canMoveChest(World world, BlockPos pos, IBlockState chest, EnumFacing moveDirection, ArrayList<BlockPos> chestList) {
        int type = TileEntityHelper.getChestType(world, pos);
        if (type == -1) {
            return true;
        }
        BlockPos to = pos.func_177972_a(moveDirection);
        Boolean thisDoubleChest = TileEntityHelper.isThisDoubleChest(pos, chestList);
        Boolean flag = false;
        ArrayList<BlockPos> offsetChestList = TileEntityHelper.getOffsetChestList(chestList, moveDirection);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (to.func_177972_a(enumfacing).equals((Object)pos)) continue;
            if (!chestList.contains(to.func_177972_a(enumfacing)) && TileEntityHelper.getChestType(world, to.func_177972_a(enumfacing)) == type) {
                if (flag.booleanValue() || thisDoubleChest.booleanValue() || TileEntityHelper.isDoubleChest(world, to.func_177972_a(enumfacing), chest, chestList, offsetChestList)) {
                    return false;
                }
                flag = true;
            }
            if (offsetChestList.contains(to.func_177972_a(enumfacing)) || TileEntityHelper.get_chest(world, to.func_177972_a(enumfacing)) != type) continue;
            if (flag.booleanValue() || thisDoubleChest.booleanValue() || TileEntityHelper.isDoubleChest(world, to.func_177972_a(enumfacing), chest, chestList, offsetChestList)) {
                return false;
            }
            flag = true;
        }
        return true;
    }

    public static boolean isDoubleChest(World world, BlockPos pos, IBlockState state, ArrayList<BlockPos> chestList, ArrayList<BlockPos> offsetChestList) {
        TileEntity tileEntity = null;
        if (state.func_177230_c().hasTileEntity(state)) {
            tileEntity = world.func_175625_s(pos);
        }
        int type = TileEntityHelper.getChestType(state, tileEntity);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!chestList.contains(pos.func_177972_a(enumfacing)) && TileEntityHelper.getChestType(world, pos.func_177972_a(enumfacing)) == type) {
                return true;
            }
            if (offsetChestList.contains(pos.func_177972_a(enumfacing)) || TileEntityHelper.get_chest(world, pos.func_177972_a(enumfacing)) != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisDoubleChest(BlockPos pos, ArrayList<BlockPos> chestList) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!chestList.contains(pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<BlockPos> getOffsetChestList(ArrayList<BlockPos> chestList, EnumFacing moveDirection) {
        ArrayList<BlockPos> offset = new ArrayList<BlockPos>();
        for (int i = 0; i < chestList.size(); ++i) {
            offset.add(chestList.get(i).func_177972_a(moveDirection));
        }
        return offset;
    }

    public static int getChestType(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tileEntity = null;
        if (state.func_177230_c().hasTileEntity(state)) {
            tileEntity = world.func_175625_s(pos);
        }
        return TileEntityHelper.getChestType(state, tileEntity);
    }

    public static int getChestType(IBlockState state, TileEntity tileEntity) {
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        if (movable.isBlockChest(state, tileEntity)) {
            return movable.getChestType(state, tileEntity);
        }
        return -1;
    }

    public static class UpdateData {
        private World world;
        private BlockPos pos;
        private IBlockState state;
        private TileEntity tileEntity;
        private NBTTagCompound compound;
        private IMovable movable;

        public UpdateData(World world, BlockPos pos, IBlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        public void setBlockState() {
            TileEntityHelper.unlistToAir(this.world, this.pos);
            TileEntity tileEntity = this.world.func_175625_s(this.pos);
            if (tileEntity != null) {
                this.world.func_175713_t(this.pos);
                tileEntity.func_145843_s();
            }
            this.compound = TileEntityHelper.get_tileEntity(this.world, this.pos);
            if (this.compound != null) {
                this.tileEntity = TileEntityHelper.setBlockStateWithTileEntity(this.world, this.pos, this.state, 4);
            } else {
                this.tileEntity = null;
                this.world.func_180501_a(this.pos, this.state, 4);
            }
            this.movable = MovableRegistry.getIMovable(this.state.func_177230_c());
            this.movable.move(this.world, this.state, this.tileEntity, this.compound, this.pos);
        }

        public void update() {
            this.world.markAndNotifyBlock(this.pos, this.world.func_175726_f(this.pos), this.state, this.state, 3);
            this.world.func_190524_a(this.pos, this.state.func_177230_c(), this.pos);
            this.movable.postMove(this.world, this.state, this.tileEntity, this.compound, this.pos);
        }
    }

    public static class AirData {
        private World world;
        private BlockPos pos;

        public AirData(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        public boolean equals(World world, BlockPos pos) {
            return this.world.equals(world) && this.pos.equals((Object)pos);
        }

        public void setToAir() {
            TileEntity tileEntity = this.world.func_175625_s(this.pos);
            if (tileEntity != null) {
                this.world.func_175713_t(this.pos);
                tileEntity.func_145843_s();
            }
            this.world.func_180501_a(this.pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

