/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators.BlockRotatorMoving;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class TileEntityRotator
extends TileEntity
implements ITickable {
    private IBlockState rotatorState;
    private IBlockState finalState;
    private EnumFacing.Axis rotatorAxis;
    private EnumRotate rotatorDirection;
    private BlockPos origin;
    public boolean isBase = false;
    public boolean isSticky = false;
    public EnumRotate baseDirection;
    private static final ThreadLocal<EnumFacing> MOVINE_ENTITY = new ThreadLocal<EnumFacing>(){

        @Override
        protected EnumFacing initialValue() {
            return null;
        }
    };
    private float progress;
    private float lastProgress;

    public TileEntityRotator() {
        this.rotatorState = ModulePistons.ROTATOR.func_176223_P();
        this.rotatorAxis = EnumFacing.Axis.Y;
        this.rotatorDirection = EnumRotate.clockwise;
        this.baseDirection = EnumRotate.clockwise;
    }

    public TileEntityRotator(IBlockState rotatorStateIn, EnumFacing.Axis axis, EnumRotate direction, BlockPos origin, IBlockState finalState) {
        this.rotatorState = rotatorStateIn;
        this.finalState = finalState;
        this.rotatorAxis = axis;
        this.rotatorDirection = direction;
        this.baseDirection = direction;
        this.origin = origin;
        this.func_70296_d();
    }

    public IBlockState getRotatorState() {
        return this.rotatorState;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public EnumFacing.Axis getRotationAxis() {
        return this.rotatorAxis;
    }

    public EnumRotate getRotationDirection() {
        return this.rotatorDirection;
    }

    public void setRotatorState(IBlockState state) {
        this.rotatorState = state;
    }

    public void setRotatorAxis(EnumFacing.Axis axis) {
        this.rotatorAxis = axis;
    }

    public void setRotatorDirection(EnumRotate direction) {
        this.rotatorDirection = direction;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public BlockPos getOffsetOrigin() {
        if (this.rotatorAxis == EnumFacing.Axis.X) {
            return new BlockPos(this.field_174879_c.func_177958_n(), this.origin.func_177956_o(), this.origin.func_177952_p());
        }
        if (this.rotatorAxis == EnumFacing.Axis.Y) {
            return new BlockPos(this.origin.func_177958_n(), this.field_174879_c.func_177956_o(), this.origin.func_177952_p());
        }
        return new BlockPos(this.origin.func_177958_n(), this.origin.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public void clearRotatorTileEntity() {
        if (this.lastProgress < 1.0f && this.field_145850_b != null) {
            this.lastProgress = this.progress = 1.0f;
            TileEntityHelper.setBlockState(this.field_145850_b, this.field_174879_c, this.rotateBlock(this.finalState, TileEntityHelper.get_tileEntity(this.field_145850_b, this.field_174879_c), this.field_174879_c, this.rotatorAxis, this.rotatorDirection, this.shouldReverseDirection(this.field_145850_b.func_180495_p(this.field_174879_c))));
        }
    }

    public void func_73660_a() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            TileEntityHelper.setBlockState(this.field_145850_b, this.field_174879_c, this.rotateBlock(this.finalState, TileEntityHelper.get_tileEntity(this.field_145850_b, this.field_174879_c), this.field_174879_c, this.rotatorAxis, this.rotatorDirection, this.shouldReverseDirection(this.field_145850_b.func_180495_p(this.field_174879_c))));
        } else {
            float f;
            this.progress = f = this.progress + 0.25f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public IBlockState rotateBlock(IBlockState state, NBTTagCompound compound, BlockPos pos, EnumFacing.Axis axis, EnumRotate direction, boolean reverse) {
        IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
        IBlockState iblockstate = movable.rotate(state, compound, pos, axis, direction.reverse(reverse));
        return iblockstate;
    }

    public boolean shouldReverseDirection(IBlockState state) {
        if (state.func_177230_c() instanceof BlockRotatorMoving) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
            return facing == EnumFacing.DOWN || facing == EnumFacing.WEST || facing == EnumFacing.NORTH;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.field_174879_c = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        this.rotatorState = Block.func_149729_e((int)compound.func_74762_e("blockId")).func_176203_a(compound.func_74762_e("blockData"));
        this.finalState = Block.func_149729_e((int)compound.func_74762_e("finalblockId")).func_176203_a(compound.func_74762_e("finalblockData"));
        this.rotatorAxis = EnumRotate.getAxis(compound.func_74762_e("axis"));
        this.rotatorDirection = compound.func_74767_n("direction") ? EnumRotate.clockwise : EnumRotate.counterclockwise;
        this.isBase = compound.func_74767_n("base");
        this.progress = compound.func_74760_g("progress");
        this.origin = new BlockPos(compound.func_74762_e("ox"), compound.func_74762_e("oy"), compound.func_74762_e("oz"));
        this.lastProgress = this.progress;
        if (compound.func_74764_b("tileEntity")) {
            TileEntityHelper.add_tileEntity(this.field_145850_b, this.field_174879_c, compound.func_74775_l("tileEntity"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("blockId", Block.func_149682_b((Block)this.rotatorState.func_177230_c()));
        compound.func_74768_a("blockData", this.rotatorState.func_177230_c().func_176201_c(this.rotatorState));
        compound.func_74768_a("finalblockId", Block.func_149682_b((Block)this.finalState.func_177230_c()));
        compound.func_74768_a("finalblockData", this.rotatorState.func_177230_c().func_176201_c(this.finalState));
        compound.func_74768_a("axis", EnumRotate.getAxisID(this.rotatorAxis));
        compound.func_74757_a("direction", this.rotatorDirection == EnumRotate.clockwise);
        compound.func_74757_a("base", this.isBase);
        compound.func_74776_a("progress", this.lastProgress);
        compound.func_74768_a("ox", this.origin.func_177958_n());
        compound.func_74768_a("oy", this.origin.func_177956_o());
        compound.func_74768_a("oz", this.origin.func_177952_p());
        NBTTagCompound tileEntity = TileEntityHelper.get_tileEntity(this.field_145850_b, this.field_174879_c);
        if (tileEntity != null) {
            compound.func_74782_a("tileEntity", (NBTBase)tileEntity);
        }
        return compound;
    }

    public AxisAlignedBB getAABB(IBlockAccess world, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * ticks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetX(float ticks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetY(float ticks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetZ(float ticks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

