/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Rotators;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import sandro.RedstonePlusPlus.API.Movable.EnumRotate;

public class AxisAlignedRotation {
    private Vec v1;
    private Vec v2;
    private Vec offset;

    public AxisAlignedRotation(AxisAlignedBB aabb) {
        this(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public AxisAlignedRotation(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Vec(x1, y1, z1), new Vec(x2, y2, z2));
    }

    public AxisAlignedRotation(Vec v1, Vec v2) {
        this.v1 = v1;
        this.v2 = v2;
        this.offset = new Vec(0.0, 0.0, 0.0);
    }

    public void setOffest(BlockPos origin, BlockPos pos) {
        double x = (double)(pos.func_177958_n() - origin.func_177958_n()) + 0.5;
        double y = (double)(pos.func_177956_o() - origin.func_177956_o()) + 0.5;
        double z = (double)(pos.func_177952_p() - origin.func_177952_p()) + 0.5;
        this.setOffest(x, y, z);
    }

    public void setOffest(double x, double y, double z) {
        this.setOffest(new Vec(x, y, z));
    }

    public void setOffest(Vec offest) {
        this.offset = offest;
    }

    public Vec getOffset() {
        return this.offset;
    }

    public AxisAlignedBB getAxisAlignedBB() {
        return this.getAxisAlignedBB(this.v1, this.v2);
    }

    public AxisAlignedBB getAxisAlignedBB(Vec v1, Vec v2) {
        double x1 = Math.min(v1.x, v2.x);
        double y1 = Math.min(v1.y, v2.y);
        double z1 = Math.min(v1.z, v2.z);
        double x2 = Math.max(v1.x, v2.x);
        double y2 = Math.max(v1.y, v2.y);
        double z2 = Math.max(v1.z, v2.z);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public AxisAlignedBB rotate(EnumFacing.Axis axis, EnumRotate direction, double angle) {
        Vec vec1 = this.v1.offset(this.offset).rotate(axis, direction, angle);
        Vec vec2 = this.v2.offset(this.offset).rotate(axis, direction, angle);
        return this.getAxisAlignedBB(vec1, vec2);
    }

    public static class Vec {
        public double x;
        public double y;
        public double z;

        public Vec(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec offset(Vec vec) {
            return this.offset(vec.x, vec.y, vec.z);
        }

        public Vec offset(double x, double y, double z) {
            return new Vec(this.x + x, this.y + y, this.z + z);
        }

        public Vec rotate(EnumFacing.Axis axis, EnumRotate direction, double angle) {
            return this.rotate(axis, direction == EnumRotate.clockwise ? 360.0 - angle : angle);
        }

        private Vec rotate(EnumFacing.Axis axis, double angle) {
            if (axis == EnumFacing.Axis.X) {
                return this.rotateX(angle);
            }
            if (axis == EnumFacing.Axis.Y) {
                return this.rotateY(angle);
            }
            return this.rotateZ(angle);
        }

        private Vec rotateX(double a) {
            double y1 = this.y * Math.cos(a) - this.z * Math.sin(a);
            double z1 = this.y * Math.sin(a) + this.z * Math.cos(a);
            return new Vec(this.x, y1, z1);
        }

        private Vec rotateY(double a) {
            double x1 = this.x * Math.cos(a) + this.z * Math.sin(a);
            double z1 = -this.x * Math.sin(a) + this.z * Math.cos(a);
            return new Vec(x1, this.y, z1);
        }

        private Vec rotateZ(double a) {
            double x1 = this.x * Math.cos(a) - this.y * Math.sin(a);
            double y1 = this.x * Math.sin(a) + this.y * Math.cos(a);
            return new Vec(x1, y1, this.z);
        }
    }
}

