/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.MovableRegistry;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons.BlockPistonMovingFix;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.Pistons.BlockPistonStructureHelperFix;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class BlockPistonBaseFix
extends BlockPistonBase {
    protected static final AxisAlignedBB PISTON_BASE_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_WEST_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB PISTON_BASE_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_DOWN_AABB = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
    private final boolean isSticky;

    public BlockPistonBaseFix(boolean isSticky) {
        super(isSticky);
        this.isSticky = isSticky;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_176214_u(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) == false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
                case DOWN: {
                    return PISTON_BASE_DOWN_AABB;
                }
                default: {
                    return PISTON_BASE_UP_AABB;
                }
                case NORTH: {
                    return PISTON_BASE_NORTH_AABB;
                }
                case SOUTH: {
                    return PISTON_BASE_SOUTH_AABB;
                }
                case WEST: {
                    return PISTON_BASE_WEST_AABB;
                }
                case EAST: 
            }
            return PISTON_BASE_EAST_AABB;
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockPistonBaseFix.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)worldIn, pos));
    }

    public boolean isFullyOpaque(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) == false || state.func_177229_b((IProperty)field_176387_N) == EnumFacing.DOWN;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        if (!worldIn.field_72995_K) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(false));
    }

    private void checkForMove(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
        if (flag && !((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            if (new BlockPistonStructureHelperFix(worldIn, pos, enumfacing, true).func_177253_a()) {
                worldIn.func_175641_c(pos, (Block)this, 0, enumfacing.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            BlockPos blockpos = new BlockPos((Vec3i)pos).func_177982_a(enumfacing.func_82601_c() * 2, enumfacing.func_96559_d() * 2, enumfacing.func_82599_e() * 2);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            int pullable = 0;
            if (block != Blocks.field_180384_M) {
                pullable = 16;
            }
            worldIn.func_175641_c(pos, (Block)this, 1, enumfacing.func_176745_a() | pullable);
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, EnumFacing facing) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing == facing || !worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            if (enumfacing1 == EnumFacing.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        if (!worldIn.field_72995_K) {
            boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
            if (flag && id == 1) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.doMove(worldIn, pos, enumfacing, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1) {
            TileEntity tileentity1 = worldIn.func_175625_s(pos.func_177972_a(enumfacing));
            if (tileentity1 instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity1).func_145866_f();
            }
            worldIn.func_180501_a(pos, Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)enumfacing).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)(this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT)), 3);
            worldIn.func_175690_a(pos, BlockPistonMovingFix.createTilePiston(this.func_176203_a(param), enumfacing, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity;
                BlockPos blockpos = pos.func_177982_a(enumfacing.func_82601_c() * 2, enumfacing.func_96559_d() * 2, enumfacing.func_82599_e() * 2);
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                boolean flag1 = false;
                if (block == Blocks.field_180384_M && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).func_174930_e() == enumfacing && tileentitypiston.func_145868_b()) {
                    tileentitypiston.func_145866_f();
                    flag1 = true;
                }
                if ((param & 0x10) != 0 && !flag1 && !iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, pos) && BlockPistonBaseFix.canPush(iblockstate, worldIn, blockpos, enumfacing.func_176734_d(), false, enumfacing)) {
                    this.doMove(worldIn, pos, enumfacing, false);
                }
            } else {
                worldIn.func_175698_g(pos.func_177972_a(enumfacing));
            }
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @Nullable
    public static EnumFacing getFacing(int meta) {
        int i = meta & 7;
        return i > 5 ? null : EnumFacing.func_82600_a((int)i);
    }

    public static boolean canPush(IBlockState state, World world, BlockPos pos, EnumFacing facing, boolean destroyBlocks, EnumFacing direction) {
        Block block = state.func_177230_c();
        IMovable movable = MovableRegistry.getIMovable(block);
        TileEntity tileEntity = null;
        if (block.hasTileEntity(state)) {
            if (!ModulePistons.push_te) {
                return false;
            }
            tileEntity = world.func_175625_s(pos);
        }
        if (!movable.canMove(world, state, tileEntity, pos)) {
            return false;
        }
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (!(pos.func_177956_o() < 0 || facing == EnumFacing.DOWN && pos.func_177956_o() == 0 || pos.func_177956_o() > world.func_72800_K() - 1 || facing == EnumFacing.UP && pos.func_177956_o() == world.func_72800_K() - 1)) {
            if (!movable.canPush(world, state, tileEntity, pos, pos.func_177972_a(facing), facing, direction.func_176734_d())) {
                return false;
            }
            if (movable.isDestroyedOnMove(world, state, tileEntity, pos)) {
                return destroyBlocks;
            }
            if (facing != direction) {
                boolean flg = movable.willSideStick(world, state, tileEntity, pos, direction.func_176734_d());
                return flg;
            }
            return true;
        }
        return false;
    }

    private boolean doMove(World world, BlockPos pos, EnumFacing direction, boolean extending) {
        BlockPistonStructureHelperFix blockpistonstructurehelper;
        if (!extending) {
            world.func_175698_g(pos.func_177972_a(direction));
        }
        if (!(blockpistonstructurehelper = new BlockPistonStructureHelperFix(world, pos, direction, extending)).func_177253_a()) {
            return false;
        }
        List<BlockPos> list = blockpistonstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        EnumFacing enumfacing = extending ? direction : direction.func_176734_d();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos = list.get(i);
            IBlockState state = world.func_180495_p(blockpos).func_185899_b((IBlockAccess)world, blockpos);
            list1.add(state);
            BlockPos toPos = extending ? blockpos.func_177972_a(direction) : blockpos.func_177972_a(direction.func_176734_d());
            TileEntity tileEntity = null;
            if (state.func_177230_c().hasTileEntity(state)) {
                tileEntity = world.func_175625_s(blockpos);
                TileEntityHelper.add_tileEntity(world, toPos, tileEntity);
            }
            IMovable movable = MovableRegistry.getIMovable(state.func_177230_c());
            movable.preMove(world, state, tileEntity, TileEntityHelper.get_tileEntity(world, toPos), blockpos, toPos);
        }
        List<BlockPos> list2 = blockpistonstructurehelper.func_177252_d();
        int k = list.size() + list2.size();
        IBlockState[] aiblockstate = new IBlockState[k];
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos1 = list2.get(j);
            IBlockState iblockstate = world.func_180495_p(blockpos1);
            float chance = iblockstate.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
            iblockstate.func_177230_c().func_180653_a(world, blockpos1, iblockstate, chance, 0);
            world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 4);
            aiblockstate[--k] = iblockstate;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            IBlockState iblockstate2 = world.func_180495_p(blockpos3);
            world.func_180501_a(blockpos3, Blocks.field_150350_a.func_176223_P(), 2);
            BlockPos blockpos3_2 = blockpos3.func_177972_a(enumfacing);
            world.func_180501_a(blockpos3_2, Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)direction), 4);
            world.func_175690_a(blockpos3_2, BlockPistonMovingFix.createTilePiston((IBlockState)list1.get(l), direction, extending, false));
            blockpos3 = blockpos3_2;
            aiblockstate[--k] = iblockstate2;
        }
        BlockPos blockpos2 = pos.func_177972_a(direction);
        if (extending) {
            BlockPistonExtension.EnumPistonType blockpistonextension$enumpistontype = this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT;
            IBlockState iblockstate3 = Blocks.field_150332_K.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)direction).func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)blockpistonextension$enumpistontype);
            IBlockState iblockstate1 = Blocks.field_180384_M.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)direction).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)(this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT));
            world.func_180501_a(blockpos2, iblockstate1, 4);
            world.func_175690_a(blockpos2, BlockPistonMovingFix.createTilePiston(iblockstate3, direction, true, true));
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            world.func_175685_c(list2.get(i1), aiblockstate[k++].func_177230_c(), false);
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            world.func_175685_c(list.get(j1), aiblockstate[k++].func_177230_c(), false);
        }
        if (extending) {
            world.func_175685_c(blockpos2, (Block)Blocks.field_150332_K, false);
        }
        List<BlockPos> chestUpdateList = blockpistonstructurehelper.getChestUpdateList();
        for (int i4 = 0; i4 < chestUpdateList.size(); ++i4) {
            BlockPos posi4 = chestUpdateList.get(i4);
            IBlockState chestState = world.func_180495_p(posi4);
            if (!(chestState.func_177230_c() instanceof BlockChest)) continue;
            BlockChest blockChest = (BlockChest)chestState.func_177230_c();
            TileEntity tileEntity4 = world.func_175625_s(posi4);
            if (tileEntity4 != null && tileEntity4 instanceof TileEntityChest) {
                ((TileEntityChest)tileEntity4).func_145836_u();
                ((TileEntityChest)tileEntity4).func_145979_i();
            }
            blockChest.func_176455_e(world, posi4, chestState);
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockPistonBaseFix.getFacing(meta)).func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, field_176320_b});
    }
}

