/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedMinecarts;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import sandro.Core.Main;
import sandro.Core.PatchLibrary.ChunkLoading.ChunkLoader;
import sandro.Core.PatchLibrary.Entity.IEntityMessage;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.Modules.ImprovedMinecarts.ContainerFurnaceMinecart;
import sandro.RedstonePlusPlus.Modules.ImprovedMinecarts.ModuleMinecarts;

public class EntityMinecartFurnaceFix
extends EntityMinecartFurnace
implements ILockableContainer,
IEntityAdditionalSpawnData,
IEntityMessage {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityMinecartFurnace.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean dropContentsWhenDead = true;
    private int fuel;
    private int fuelScale;
    public boolean isPowered = false;
    private double speed = 0.0;
    private boolean isInReverse;
    private ForgeChunkManager.Ticket ticket;
    private ArrayList<ChunkPos> chunks = new ArrayList();
    private IInventory inventory = new InventoryBasic("", false, 1);

    public EntityMinecartFurnaceFix() {
        super(null);
    }

    public EntityMinecartFurnaceFix(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartFurnaceFix(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public static void registerFixesMinecartFurnace(DataFixer fixer) {
        EntityMinecart.func_189669_a((DataFixer)fixer, EntityMinecartFurnace.class);
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.FURNACE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public static EntityMinecart create(World worldIn, double x, double y, double z, EntityMinecart.Type typeIn) {
        switch (typeIn) {
            case CHEST: {
                return new EntityMinecartChest(worldIn, x, y, z);
            }
            case FURNACE: {
                return new EntityMinecartFurnaceFix(worldIn, x, y, z);
            }
            case TNT: {
                return new EntityMinecartTNT(worldIn, x, y, z);
            }
            case SPAWNER: {
                return new EntityMinecartMobSpawner(worldIn, x, y, z);
            }
            case HOPPER: {
                return new EntityMinecartHopper(worldIn, x, y, z);
            }
            case COMMAND_BLOCK: {
                return new EntityMinecartCommandBlock(worldIn, x, y, z);
            }
        }
        return new EntityMinecartEmpty(worldIn, x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.fuel > 0) {
            --this.fuel;
        } else if (this.isPowered && !this.inventory.func_191420_l()) {
            this.fuelMinecart();
        } else {
            this.isPowered = false;
            this.speed = 0.0;
        }
        this.func_94107_f(this.fuel > 0);
        if (this.func_94108_c() && this.field_70146_Z.nextInt(4) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_94108_c() && ModuleMinecarts.enableChunkLoading && !this.field_70128_L) {
                this.forceChunkLoading(this.field_70176_ah, this.field_70164_aj);
            } else {
                this.releaseTicket();
            }
        }
    }

    protected void fuelMinecart() {
        ItemStack itemstack = this.inventory.func_70301_a(0);
        this.fuelScale = this.fuel = Registry.FURNACE.getFuelValue(itemstack);
        Item item = itemstack.func_77973_b();
        itemstack.func_190918_g(1);
        if (itemstack.func_190926_b()) {
            ItemStack item1 = item.getContainerItem(itemstack);
            this.inventory.func_70299_a(0, item1);
        }
    }

    public int getFuelLeftScale(int pixels) {
        int i = this.fuelScale;
        if (i == 0) {
            i = 200;
        }
        return this.fuel * pixels / i;
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.dropItems();
        }
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        this.dropContentsWhenDead = false;
        return super.func_184204_a(dimensionIn);
    }

    public void func_70106_y() {
        if (this.dropContentsWhenDead) {
            this.dropItems();
        }
        super.func_70106_y();
    }

    public void dropItems() {
        ItemStack itemstack = this.inventory.func_70301_a(0);
        if (!itemstack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)(this.field_70163_u + 0.8), (double)this.field_70161_v, (ItemStack)itemstack);
            this.inventory.func_174888_l();
        }
    }

    public void func_184174_b(boolean dropWhenDead) {
        this.dropContentsWhenDead = dropWhenDead;
    }

    protected void func_180460_a(BlockPos pos, IBlockState state) {
        super.func_180460_a(pos, state);
    }

    protected void func_94101_h() {
        super.func_94101_h();
        if (this.getCurrentSpeed() < 0.2) {
            double yaw = (double)this.field_70177_z * Math.PI / 180.0;
            this.field_70159_w += Math.cos(yaw) * this.speed;
            this.field_70179_y += Math.sin(yaw) * this.speed;
            this.field_70159_w = Math.copySign(Math.min(Math.abs(this.field_70159_w), 0.2), this.field_70159_w);
            this.field_70179_y = Math.copySign(Math.min(Math.abs(this.field_70179_y), 0.2), this.field_70179_y);
        }
    }

    private double getCurrentSpeed() {
        return Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70179_y, 2.0));
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (this.isPowered) {
                this.speed = 0.0;
                this.isPowered = false;
                this.func_94107_f(false);
                this.fuel = 0;
            } else if (Registry.FURNACE.getFuelValue(player.func_184586_b(hand)) > 0) {
                ItemStack itemstack = player.func_184586_b(hand);
                this.fuelScale = this.fuel = Registry.FURNACE.getFuelValue(itemstack);
                Item item = itemstack.func_77973_b();
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    ItemStack item1 = item.getContainerItem(itemstack);
                    player.func_184611_a(hand, item1);
                }
                this.moveInDirection(this.getAngle(player.field_70165_t, player.field_70161_v, this.field_70165_t, this.field_70161_v));
                this.isPowered = true;
                this.func_94107_f(true);
            } else if (!this.inventory.func_191420_l()) {
                this.moveInDirection(this.getAngle(player.field_70165_t, player.field_70161_v, this.field_70165_t, this.field_70161_v));
                this.fuelMinecart();
                this.isPowered = true;
                this.func_94107_f(true);
            }
        } else {
            player.openGui((Object)Main.instance, 1, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        return true;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockRailBase blockrailbase = (BlockRailBase)this.field_70170_p.func_180495_p(pos).func_177230_c();
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = blockrailbase.getRailDirection((IBlockAccess)this.field_70170_p, pos, this.field_70170_p.func_180495_p(pos), (EntityMinecart)this);
        boolean prevPowered = this.isPowered;
        if (receivingPower) {
            if (!this.isPowered && !this.inventory.func_191420_l()) {
                if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.EAST_WEST) {
                    if (this.field_70170_p.func_180495_p(pos.func_177976_e()).func_185915_l()) {
                        this.moveInDirection(EnumFacing.EAST);
                    } else if (this.field_70170_p.func_180495_p(pos.func_177974_f()).func_185915_l()) {
                        this.moveInDirection(EnumFacing.WEST);
                    }
                } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                    if (this.field_70170_p.func_180495_p(pos.func_177978_c()).func_185915_l()) {
                        this.moveInDirection(EnumFacing.SOUTH);
                    } else if (this.field_70170_p.func_180495_p(pos.func_177968_d()).func_185915_l()) {
                        this.moveInDirection(EnumFacing.NORTH);
                    }
                }
                this.fuelMinecart();
                this.isPowered = true;
                this.func_94107_f(true);
            }
        } else {
            this.speed = 0.0;
            this.isPowered = false;
            this.func_94107_f(false);
            this.fuel = 0;
        }
        if (this.isPowered != prevPowered && !this.field_70170_p.field_72995_K) {
            Registry.NETWORK.sendEntityMessage(this);
        }
    }

    private float getAngle(EnumFacing direction) {
        if (direction.compareTo((Enum)EnumFacing.NORTH) == 0) {
            return 90.0f;
        }
        if (direction.compareTo((Enum)EnumFacing.EAST) == 0) {
            return 180.0f;
        }
        if (direction.compareTo((Enum)EnumFacing.SOUTH) == 0) {
            return -90.0f;
        }
        return 0.0f;
    }

    public void moveInDirection(double direction) {
        direction += 180.0;
        EnumFacing f = EnumFacing.SOUTH;
        if (direction >= 45.0 && direction < 135.0) {
            f = EnumFacing.EAST;
        }
        if (direction >= 135.0 && direction < 225.0) {
            f = EnumFacing.NORTH;
        }
        if (direction >= 225.0 && direction < 315.0) {
            f = EnumFacing.WEST;
        }
        this.moveInDirection(f);
    }

    public void moveInDirection(EnumFacing direction) {
        if (direction == EnumFacing.NORTH) {
            this.speed = this.func_174898_m();
            if ((this.field_70177_z - 270.0f) % 360.0f != 0.0f) {
                this.speed *= -1.0;
            }
            this.field_70179_y = -0.02;
        } else if (direction == EnumFacing.SOUTH) {
            this.speed = this.func_174898_m();
            if ((this.field_70177_z - 90.0f) % 360.0f != 0.0f) {
                this.speed *= -1.0;
            }
            this.field_70179_y = 0.02;
        } else if (direction == EnumFacing.EAST) {
            this.speed = this.func_174898_m();
            if ((this.field_70177_z - 0.0f) % 360.0f != 0.0f) {
                this.speed *= -1.0;
            }
            this.field_70159_w = 0.02;
        } else {
            this.speed = this.func_174898_m();
            if ((this.field_70177_z - 180.0f) % 360.0f != 0.0f) {
                this.speed *= -1.0;
            }
            this.field_70159_w = -0.02;
        }
    }

    public static void addDataFixers(DataFixer p_190574_0_, Class<?> p_190574_1_) {
        EntityMinecart.func_189669_a((DataFixer)p_190574_0_, p_190574_1_);
        p_190574_0_.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(p_190574_1_, new String[]{"Items"}));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a("Speed", this.speed);
        compound.func_74777_a("Fuel", (short)this.fuel);
        compound.func_74777_a("FuelScale", (short)this.fuelScale);
        compound.func_74757_a("isPowered", this.isPowered);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.getItems());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.speed = compound.func_74769_h("Speed");
        this.fuel = compound.func_74765_d("Fuel");
        this.fuelScale = compound.func_74765_d("FuelScale");
        this.isPowered = compound.func_74767_n("isPowered");
        if (this.isPowered) {
            this.func_94107_f(true);
        }
        NonNullList list = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, (NonNullList)list);
        this.inventory.func_70299_a(0, (ItemStack)list.get(0));
    }

    public boolean func_94108_c() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected void func_94107_f(boolean p_94107_1_) {
        this.field_70180_af.func_187227_b(POWERED, (Object)p_94107_1_);
    }

    public boolean isPoweredCart() {
        return this.func_94108_c();
    }

    public IBlockState func_180457_u() {
        return (this.func_94108_c() ? Blocks.field_150470_am : Blocks.field_150460_al).func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.NORTH);
    }

    protected NonNullList<ItemStack> getItems() {
        return NonNullList.func_191197_a((int)1, (Object)this.inventory.func_70301_a(0));
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.fuel;
            }
            case 1: {
                return this.fuelScale;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.fuel = value;
                return;
            }
            case 1: {
                this.fuelScale = value;
                return;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return this.getContainer(playerIn);
    }

    public String func_174875_k() {
        return null;
    }

    public boolean func_174893_q_() {
        return false;
    }

    public void func_174892_a(LockCode code) {
    }

    public LockCode func_174891_i() {
        return null;
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerFurnaceMinecart((IInventory)player.field_71071_by, this, player);
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.writeData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.readData(buffer);
    }

    public double getAngle(double x1, double z1, double x2, double z2) {
        double theta = Math.atan2(x1 - x2, z1 - z2);
        double angle = Math.toDegrees(theta);
        return angle % 360.0;
    }

    @Override
    public void readData(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        try {
            this.inventory.func_70299_a(0, packet.func_150791_c());
            this.isPowered = packet.readBoolean();
            if (this.isPowered) {
                this.func_94107_f(true);
            }
            this.fuel = packet.readInt();
            this.fuelScale = packet.readInt();
            this.speed = packet.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        packet.func_150788_a(this.inventory.func_70301_a(0));
        packet.writeBoolean(this.isPowered);
        packet.writeInt(this.fuel);
        packet.writeInt(this.fuelScale);
        packet.writeDouble(this.speed);
    }

    private boolean requestTicket() {
        this.ticket = ChunkLoader.requestTicket(this.field_70170_p, ForgeChunkManager.Type.ENTITY, 1);
        if (this.ticket != null) {
            this.ticket.setChunkListDepth(9);
            this.ticket.bindEntity((Entity)this);
            return true;
        }
        return false;
    }

    public void releaseTicket() {
        if (this.ticket != null) {
            ChunkLoader.releaseTicket(this.ticket);
            this.ticket = null;
        }
    }

    private void forceChunkLoading(int x, int z) {
        if (this.ticket == null && !this.requestTicket()) {
            return;
        }
        ArrayList<ChunkPos> oldChunks = this.chunks;
        this.chunks = new ArrayList();
        this.forceChunk(x - 1, z - 1, oldChunks);
        this.forceChunk(x + 1, z - 1, oldChunks);
        this.forceChunk(x - 1, z + 1, oldChunks);
        this.forceChunk(x + 1, z + 1, oldChunks);
        this.forceChunk(x - 1, z, oldChunks);
        this.forceChunk(x + 1, z, oldChunks);
        this.forceChunk(x, z - 1, oldChunks);
        this.forceChunk(x, z + 1, oldChunks);
        this.forceChunk(x, z, oldChunks);
        if (oldChunks.size() > 0) {
            ChunkLoader.setChunkList(this.ticket, this.chunks);
            for (int i = 0; i < oldChunks.size(); ++i) {
                ChunkLoader.unforceChunk(this.ticket, oldChunks.get(i));
            }
        }
    }

    private void forceChunk(int x, int z, ArrayList<ChunkPos> oldChunks) {
        ChunkPos pos = new ChunkPos(x, z);
        if (oldChunks.contains(pos)) {
            oldChunks.remove(pos);
        } else {
            ChunkLoader.forceChunk(this.ticket, pos);
        }
        ChunkLoader.reorderChunk(this.ticket, pos);
        this.chunks.add(pos);
    }
}

