/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedDispensers;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.World;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.IDispenserBehaviour;
import sandro.RedstonePlusPlus.Modules.ImprovedDispensers.ModuleDispensers;

public class BlockDispenserFix
extends BlockDispenser {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> DISPENSE_BEHAVIOR_REGISTRY = BlockDispenser.field_149943_a;
    protected Random field_149942_b = new Random();
    public static final ArrayList<IDispenserBehaviour> DISPENSER_BEHAVIOUR_HOOK = new ArrayList();
    public static final BehaviorDefaultDispenseItem DEFAULT = new BehaviorDefaultDispenseItem();

    public BlockDispenserFix() {
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149738_a(World worldIn) {
        return 4;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    private void setDefaultDirection(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean flag = worldIn.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = worldIn.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = worldIn.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = worldIn.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDispenser) {
            playerIn.func_71007_a((IInventory)((TileEntityDispenser)tileentity));
            if (tileentity instanceof TileEntityDropper) {
                playerIn.func_71029_a(StatList.field_188083_Q);
            } else {
                playerIn.func_71029_a(StatList.field_188085_S);
            }
        }
        return true;
    }

    protected void func_176439_d(World worldIn, BlockPos pos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(worldIn, pos);
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)blocksourceimpl.func_150835_j();
        if (tileentitydispenser != null) {
            int i = tileentitydispenser.func_146017_i();
            if (i < 0) {
                IBlockState state = worldIn.func_180495_p(pos);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                int cnt = 0;
                while (true) {
                    if (cnt >= DISPENSER_BEHAVIOUR_HOOK.size()) break;
                    if (DISPENSER_BEHAVIOUR_HOOK.get(cnt).attemptDispenseEmpty(worldIn, pos, state, tileentitydispenser, facing)) {
                        return;
                    }
                    ++cnt;
                }
                worldIn.func_175718_b(1001, pos, 0);
            } else {
                ArrayList list;
                ItemStack itemstack = tileentitydispenser.func_70301_a(i);
                IBlockState state = worldIn.func_180495_p(pos);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                BlockPos offset = pos.func_177972_a(facing);
                IBlockState other = worldIn.func_180495_p(offset);
                if (other.func_177230_c() instanceof BlockLiquid && itemstack.func_77973_b() == Items.field_151133_ar) {
                    IBehaviorDispenseItem ibehaviordispenseitem = this.func_149940_a(itemstack);
                    if (ibehaviordispenseitem != IBehaviorDispenseItem.field_82483_a) {
                        tileentitydispenser.func_70299_a(i, ibehaviordispenseitem.func_82482_a((IBlockSource)blocksourceimpl, itemstack));
                    }
                    return;
                }
                if (other.func_177230_c() instanceof BlockRailBase && !(list = (ArrayList)worldIn.func_72872_a(EntityMinecart.class, field_185505_j.func_186670_a(offset))).isEmpty()) {
                    if (itemstack.func_77973_b() instanceof ItemMinecart && ModuleDispensers.fixMinecartGlitch) {
                        tileentitydispenser.func_70299_a(i, DEFAULT.func_82482_a((IBlockSource)blocksourceimpl, itemstack));
                        return;
                    }
                    if (ModuleDispensers.canPlaceBlockInMinecarts) {
                        for (int cnt = 0; cnt < list.size(); ++cnt) {
                            if (list.get(cnt) instanceof EntityMinecartEmpty && !((EntityMinecart)list.get(cnt)).func_184218_aH() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                                EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.CHEST);
                                ((EntityMinecart)list.get(cnt)).func_70106_y();
                                worldIn.func_72838_d((Entity)minecart);
                                itemstack.func_190918_g(1);
                                return;
                            }
                            if (list.get(cnt) instanceof EntityMinecartEmpty && !((EntityMinecart)list.get(cnt)).func_184218_aH() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150460_al)) {
                                EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.FURNACE);
                                ((EntityMinecart)list.get(cnt)).func_70106_y();
                                worldIn.func_72838_d((Entity)minecart);
                                itemstack.func_190918_g(1);
                                return;
                            }
                            if (list.get(cnt) instanceof EntityMinecartEmpty && !((EntityMinecart)list.get(cnt)).func_184218_aH() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                                EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.TNT);
                                ((EntityMinecart)list.get(cnt)).func_70106_y();
                                worldIn.func_72838_d((Entity)minecart);
                                itemstack.func_190918_g(1);
                                return;
                            }
                            if (list.get(cnt) instanceof EntityMinecartEmpty && !((EntityMinecart)list.get(cnt)).func_184218_aH() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150438_bZ)) {
                                EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.HOPPER);
                                ((EntityMinecart)list.get(cnt)).func_70106_y();
                                worldIn.func_72838_d((Entity)minecart);
                                itemstack.func_190918_g(1);
                                return;
                            }
                            if (list.get(cnt) instanceof EntityMinecartEmpty && !((EntityMinecart)list.get(cnt)).func_184218_aH() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150474_ac)) {
                                EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.SPAWNER);
                                ((EntityMinecart)list.get(cnt)).func_70106_y();
                                worldIn.func_72838_d((Entity)minecart);
                                itemstack.func_190918_g(1);
                                return;
                            }
                            if (!(list.get(cnt) instanceof EntityMinecartEmpty) || ((EntityMinecart)list.get(cnt)).func_184218_aH() || itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150483_bI)) continue;
                            EntityMinecart minecart = EntityMinecart.func_184263_a((World)worldIn, (double)((EntityMinecart)list.get((int)cnt)).field_70165_t, (double)((EntityMinecart)list.get((int)cnt)).field_70163_u, (double)((EntityMinecart)list.get((int)cnt)).field_70161_v, (EntityMinecart.Type)EntityMinecart.Type.COMMAND_BLOCK);
                            ((EntityMinecart)list.get(cnt)).func_70106_y();
                            worldIn.func_72838_d((Entity)minecart);
                            itemstack.func_190918_g(1);
                            return;
                        }
                    }
                }
                int cnt = 0;
                while (true) {
                    if (cnt >= DISPENSER_BEHAVIOUR_HOOK.size()) break;
                    if (DISPENSER_BEHAVIOUR_HOOK.get(cnt).attemptDispense(worldIn, pos, state, tileentitydispenser, i, itemstack, facing)) {
                        return;
                    }
                    ++cnt;
                }
                IBehaviorDispenseItem ibehaviordispenseitem = this.func_149940_a(itemstack);
                if (ibehaviordispenseitem != IBehaviorDispenseItem.field_82483_a) {
                    tileentitydispenser.func_70299_a(i, ibehaviordispenseitem.func_82482_a((IBlockSource)blocksourceimpl, itemstack));
                }
            }
        }
    }

    public void addItemStack(World world, BlockPos pos, EnumFacing facing, TileEntityDispenser tileEntity, int slot, ItemStack itemstack) {
        ItemStack itemstack1 = tileEntity.func_70301_a(slot);
        if (itemstack1.func_190926_b()) {
            tileEntity.func_70299_a(slot, itemstack);
            return;
        }
        for (int i = 0; i < 9; ++i) {
            itemstack1 = tileEntity.func_70301_a(i);
            if (!itemstack1.func_190926_b()) continue;
            tileEntity.func_70299_a(i, itemstack);
            return;
        }
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(world, pos);
        DEFAULT.func_82482_a((IBlockSource)blocksourceimpl, itemstack);
    }

    protected IBehaviorDispenseItem func_149940_a(ItemStack stack) {
        return (IBehaviorDispenseItem)DISPENSE_BEHAVIOR_REGISTRY.func_82594_a((Object)stack.func_77973_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = (Boolean)state.func_177229_b((IProperty)TRIGGERED);
        if (flag && !flag1) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.func_176439_d(worldIn, pos);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDispenser();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDispenser) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityDispenser)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static IPosition getDispensePosition(IBlockSource coords) {
        EnumFacing enumfacing = (EnumFacing)coords.func_189992_e().func_177229_b((IProperty)FACING);
        double d0 = coords.func_82615_a() + 0.7 * (double)enumfacing.func_82601_c();
        double d1 = coords.func_82617_b() + 0.7 * (double)enumfacing.func_96559_d();
        double d2 = coords.func_82616_c() + 0.7 * (double)enumfacing.func_82599_e();
        return new PositionImpl(d0, d1, d2);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }

    public void registerDispenserBehaviourHook(IDispenserBehaviour behaviour) {
        DISPENSER_BEHAVIOUR_HOOK.add(behaviour);
    }
}

