/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.Modules.ImprovedCraftingTables;

import net.minecraft.block.Block;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import sandro.Core.PatchLibrary.Config.ConfigHandler;
import sandro.Core.PatchLibrary.IPatch;
import sandro.Core.PatchLibrary.Module.IModule;
import sandro.Core.PatchLibrary.PatchLoader;
import sandro.Core.PatchRegistry.Registry;
import sandro.Core.PatchRegistry.Remapper;

public class ModuleCraftingTables
implements IModule {
    public static boolean isEnabled;
    public static BlockWorkbench CRAFTING_TABLE;
    public static int GUI_CRAFTING_TABLE;
    public static boolean moveRecipeBookButton;
    public static boolean unlockRecipes;
    public static boolean enableRecipeBook;
    public static boolean enableAdvancementsToast;
    public static boolean enableRecipesToast;
    public static boolean enableSystemToast;
    public static boolean enableTutorialsToast;
    public static boolean breakRecipeBookCompass;

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public String getName() {
        return "ImprovedCraftingTables";
    }

    @Override
    public void registerConfig(ConfigHandler config) {
        config.addCategory("crafting_table", "Crafting Table Module");
        isEnabled = config.getBool("enableAutoCrafting", true, "Allow Crafting Tables to work with Hoppers");
        config.addCategory("crafting_table.settings", "Crafting Table Settings");
        enableRecipeBook = config.getBool("enableRecipeBook", true, "Enable the default vanilla recipe book.");
        unlockRecipes = config.getBool("unlockAllRecipes", true, "Unlock all recipes for the default vanilla recipe book.");
        enableAdvancementsToast = config.getBool("enableAdvancementsToast", true, "Enable the popup messages for Advancements");
        enableRecipesToast = config.getBool("enableRecipieToast", false, "Enable the popup messages for Crafting Recipies");
        enableSystemToast = config.getBool("enableSystemToast", false, "Enable the narriator");
        enableTutorialsToast = config.getBool("enableTutorialsToast", false, "Enable the popup tutorial messages.");
        breakRecipeBookCompass = config.getBool("breakRecipeBookCompass", true, "Stops the Compass and Clock from working in the Recipe Book");
        ModuleCraftingTables.initToast();
    }

    @Override
    public void registerBlocks() {
        CRAFTING_TABLE = (BlockWorkbench)PatchLoader.getPatch("RedstonePlusPlus.Patch", "CraftingTableFix.BlockCraftingTableFix");
        Registry.GAME.subBlock(Blocks.field_150462_ai, (Block)CRAFTING_TABLE);
        Registry.GAME.registerTileEntity(PatchLoader.getPatchClass("RedstonePlusPlus.Patch", "CraftingTableFix.TileEntityCraftingTable"), "crafting_table");
        ModuleCraftingTables.registerWithCraftingTweaks();
    }

    @Override
    public void registerRemap() {
        Remapper.remapBlock("sandro:crafting_table", (Block)CRAFTING_TABLE);
    }

    public static void registerWithCraftingTweaks() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("ContainerClass", PatchLoader.getPatchName("RedstonePlusPlus.Patch", "CraftingTableFix.ContainerCraftingTableFix"));
        tagCompound.func_74768_a("GridSlotNumber", 1);
        tagCompound.func_74768_a("GridSize", 9);
        tagCompound.func_74757_a("HideButtons", false);
        tagCompound.func_74757_a("PhantomItems", false);
        tagCompound.func_74778_a("AlignToGrid", "left");
        NBTTagCompound tweak = new NBTTagCompound();
        tweak.func_74757_a("Enabled", true);
        tweak.func_74757_a("ShowButton", true);
        tagCompound.func_74782_a("TweakRotate", (NBTBase)tweak.func_74737_b());
        tagCompound.func_74782_a("TweakBalance", (NBTBase)tweak.func_74737_b());
        tagCompound.func_74782_a("TweakClear", (NBTBase)tweak.func_74737_b());
        FMLInterModComms.sendMessage((String)"craftingtweaks", (String)"RegisterProvider", (NBTTagCompound)tagCompound);
    }

    @Override
    public void Init() {
        if (CRAFTING_TABLE instanceof IPatch) {
            ((IPatch)CRAFTING_TABLE).init();
        }
    }

    @Override
    public void postInit() {
        if (Registry.INFO.isModInstalled("craftingtweaks")) {
            moveRecipeBookButton = true;
        }
    }

    public static void initToast() {
        if (!(enableAdvancementsToast && enableRecipesToast && enableSystemToast && enableTutorialsToast)) {
            Registry.TOAST.setToastPatch(true);
            Registry.TOAST.setAdvancements(enableAdvancementsToast);
            Registry.TOAST.setRecipes(enableRecipesToast);
            Registry.TOAST.setSystem(enableSystemToast);
            Registry.TOAST.setTutorials(enableTutorialsToast);
        }
    }

    static {
        moveRecipeBookButton = false;
    }
}

