/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableChest;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableDefault;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableDestroyable;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableDestroyer;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableDispenser;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableHalfObsidian;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableHopper;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableImmovable;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovablePiston;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovablePushOnly;
import sandro.RedstonePlusPlus.API.Movable.Implementations.MovableStairs;
import sandro.RedstonePlusPlus.RedMain;

public class MovableRegistry {
    private static HashMap<Block, IMovable> movableRegistry = new HashMap();
    public static final IMovable DEFAULT = new MovableDefault();
    public static final IMovable DESTROYABLE = new MovableDestroyable();
    public static final IMovable DESTROYER = new MovableDestroyer();
    public static final IMovable IMMOVABLE = new MovableImmovable();
    public static final IMovable PUSH_ONLY = new MovablePushOnly();

    public static void registerIMovable(IMovable movable) {
        List<Block> list = movable.getBlockList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            MovableRegistry.registerIMovable(list.get(i), movable);
        }
    }

    public static void registerIMovable(Block block, IMovable movable) {
        if (!movableRegistry.containsKey(block)) {
            movableRegistry.put(block, movable);
        }
    }

    public static void registerIMovable(String[] list, IMovable movable) {
        for (int i = 0; i < list.length; ++i) {
            String n = list[i];
            if (n.endsWith(":*")) {
                n = n.substring(0, n.length() - 2);
                List<Block> blocklist = Registry.PATCH.getModBlockList(n);
                for (int j = 0; j < blocklist.size(); ++j) {
                    Block block = blocklist.get(j);
                    if (block == null) continue;
                    if (movableRegistry.containsKey(block)) {
                        movableRegistry.remove(block);
                    }
                    movableRegistry.put(block, movable);
                }
                continue;
            }
            Block block = Registry.PATCH.getBlockFromName(list[i]);
            if (block == null) continue;
            if (movableRegistry.containsKey(block)) {
                movableRegistry.remove(block);
            }
            movableRegistry.put(block, movable);
        }
    }

    public static void registerIMovable(List<Object> annotations) {
        for (int i = 0; i < annotations.size(); ++i) {
            Object obj = annotations.get(i);
            if (!(obj instanceof IMovable)) continue;
            MovableRegistry.registerIMovable((IMovable)obj);
        }
    }

    public static IMovable getIMovable(Block block) {
        if (movableRegistry.containsKey(block)) {
            return movableRegistry.get(block);
        }
        if (block instanceof IMovable) {
            return (IMovable)block;
        }
        return DEFAULT;
    }

    public static void registerStandardIMovables() {
        MovableRegistry.registerIMovable(DESTROYABLE);
        MovableRegistry.registerIMovable(DESTROYER);
        MovableRegistry.registerIMovable(IMMOVABLE);
        MovableRegistry.registerIMovable(RedMain.plugins);
        MovableRegistry.registerIMovable(new MovablePiston());
        MovableRegistry.registerIMovable(new MovableChest());
        MovableRegistry.registerIMovable(new MovableHopper());
        MovableRegistry.registerIMovable(new MovableDispenser());
        MovableRegistry.registerIMovable(new MovableHalfObsidian());
        MovableRegistry.registerIMovable(new MovableStairs());
    }

    public static void printIMovableMappings() {
        List<Block> list = Registry.PATCH.getBlockList();
        for (int i = 0; i < list.size(); ++i) {
            Block block = list.get(i);
            IMovable movable = MovableRegistry.getIMovable(block);
            System.out.println(block.toString() + " is mapped to " + movable.toString());
        }
    }
}

