/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable.Implementations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.IMovable;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.ModulePistons;
import vazkii.quark.automation.block.BlockColorSlime;

public class MovableColorSlime
implements IMovable {
    @Override
    public List<Block> getBlockList() {
        ArrayList<Block> list = new ArrayList<Block>();
        List<Block> blocklist = Registry.PATCH.getBlockList();
        for (int i = 0; i < blocklist.size(); ++i) {
            Block block = blocklist.get(i);
            if (!(block instanceof BlockColorSlime)) continue;
            list.add(block);
        }
        list.add(Blocks.field_180399_cE);
        return list;
    }

    @Override
    public boolean isSticky(IBlockState state, TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean isSideSticky(World world, IBlockState state, TileEntity tileEntity, BlockPos pos, EnumFacing side) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(side));
        return this.doBlocksStick(state, other);
    }

    public boolean doBlocksStick(IBlockState state, IBlockState other) {
        SlimeColor thisColor = SlimeColor.get(state);
        SlimeColor otherColor = SlimeColor.get(other);
        if (thisColor == null || otherColor == null) {
            return true;
        }
        return thisColor.canStick(otherColor);
    }

    public static enum SlimeColor {
        SLIME_GREEN(1, 41),
        SLIME_RED(2, 50),
        SLIME_BLUE(4, 28),
        SLIME_CYAN(8, 13),
        SLIME_MAGENTA(16, 22),
        SLIME_YELLOW(32, 35);

        private final int slf;
        private final int flg;

        private SlimeColor(int slf, int flg) {
            this.slf = slf;
            this.flg = flg;
        }

        public static SlimeColor get(IBlockState state) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_180399_cE || block == ModulePistons.HALF_SLIME) {
                return SLIME_GREEN;
            }
            if (block instanceof BlockColorSlime) {
                BlockColorSlime block1 = (BlockColorSlime)block;
                BlockColorSlime.Variants variant = (BlockColorSlime.Variants)state.func_177229_b(block1.getVariantProp());
                switch (variant) {
                    case SLIME_RED: {
                        return SLIME_RED;
                    }
                    case SLIME_BLUE: {
                        return SLIME_BLUE;
                    }
                    case SLIME_CYAN: {
                        return SLIME_CYAN;
                    }
                    case SLIME_MAGENTA: {
                        return SLIME_MAGENTA;
                    }
                    case SLIME_YELLOW: {
                        return SLIME_YELLOW;
                    }
                }
                return null;
            }
            if (block == ModulePistons.HALF_SLIME_RED) {
                return SLIME_RED;
            }
            if (block == ModulePistons.HALF_SLIME_BLUE) {
                return SLIME_BLUE;
            }
            if (block == ModulePistons.HALF_SLIME_CYAN) {
                return SLIME_CYAN;
            }
            if (block == ModulePistons.HALF_SLIME_MAGENTA) {
                return SLIME_MAGENTA;
            }
            if (block == ModulePistons.HALF_SLIME_YELLOW) {
                return SLIME_YELLOW;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case SLIME_GREEN: {
                    return "Green";
                }
                case SLIME_RED: {
                    return "Red";
                }
                case SLIME_BLUE: {
                    return "Blue";
                }
                case SLIME_CYAN: {
                    return "Cyan";
                }
                case SLIME_MAGENTA: {
                    return "Magenta";
                }
                case SLIME_YELLOW: {
                    return "Yellow";
                }
            }
            return "Null";
        }

        public boolean canStick(SlimeColor color) {
            int test2 = this.flg & color.slf;
            System.out.println(this.toString() + "(" + this.flg + ") & " + color.toString() + "(" + color.slf + ") = " + test2);
            return (this.flg & color.slf) > 0;
        }
    }
}

