/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstonePlusPlus.API.Movable.Implementations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelChest;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sandro.Core.PatchLibrary.SpecialRenderer.IRenderer;
import sandro.Core.PatchRegistry.Registry;
import sandro.RedstonePlusPlus.API.Movable.IMovableClient;
import sandro.RedstonePlusPlus.Modules.ImprovedPistons.TileEntityHelper.TileEntityHelper;

public class MovableChestClient
implements IMovableClient {
    @SideOnly(value=Side.CLIENT)
    private ModelChest simpleChest = null;
    private static final ResourceLocation TEXTURE_TRAPPED = new ResourceLocation("textures/entity/chest/trapped.png");
    private static final ResourceLocation TEXTURE_CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("textures/entity/chest/normal.png");
    private static final ResourceLocation ENDER_CHEST_TEXTURE = new ResourceLocation("textures/entity/chest/ender.png");
    private Block QUARK_CHEST = null;
    private Block QUARK_CHEST_TRAP = null;
    private Block IRON_CHEST = null;

    @Override
    public List<Block> getBlockList() {
        Block block;
        ArrayList<Block> list = new ArrayList<Block>();
        list.add((Block)Blocks.field_150486_ae);
        list.add(Blocks.field_150447_bR);
        list.add(Blocks.field_150477_bB);
        if (Registry.INFO.isModInstalled("quark")) {
            block = Registry.PATCH.getBlockFromName("quark:custom_chest");
            if (block != null) {
                this.QUARK_CHEST = block;
                list.add(block);
            }
            if ((block = Registry.PATCH.getBlockFromName("quark:custom_chest_trap")) != null) {
                this.QUARK_CHEST_TRAP = block;
                list.add(block);
            }
        }
        if (Registry.INFO.isModInstalled("ironchest") && (block = Registry.PATCH.getBlockFromName("ironchest:iron_chest")) != null) {
            this.IRON_CHEST = block;
            list.add(block);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IRenderer renderer, BlockPos pos, IBlockState state, TileEntity tileEntity, double x, double y, double z, BlockPos origin, EnumFacing.Axis axis, float angle) {
        ResourceLocation tex;
        if (this.simpleChest == null) {
            this.simpleChest = new ModelChest();
        }
        if ((tex = this.getChestTexture(state, pos, renderer.isChristmas())) == null) {
            return;
        }
        renderer.bindTexture(tex.toString());
        renderer.pushMatrix();
        double ox = origin.func_177958_n() - pos.func_177958_n();
        double oy = origin.func_177956_o() - pos.func_177956_o();
        double oz = origin.func_177952_p() - pos.func_177952_p();
        renderer.setTranslation(ox + 0.5 + x, oy + 0.5 + y, oz + 0.5 + z);
        renderer.setRotation(axis, angle);
        renderer.pushMatrix();
        renderer.setTranslation((ox + 0.5) * -1.0, (oy + 0.5) * -1.0, (oz + 0.5) * -1.0);
        renderer.enableRescaleNormal();
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        renderer.setTranslation(0.0, 1.0, 1.0);
        renderer.setScale(1.0f, -1.0f, -1.0f);
        renderer.setTranslation(0.5, 0.5, 0.5);
        int i = this.getChestFacing(state, pos);
        int j = 0;
        switch (i) {
            case 2: {
                j = 180;
                break;
            }
            case 4: {
                j = 90;
                break;
            }
            case 5: {
                j = -90;
            }
        }
        renderer.setRotation(EnumFacing.Axis.Y, j);
        renderer.setTranslation(-0.5, -0.5, -0.5);
        this.simpleChest.func_78231_a();
        renderer.disableRescaleNormal();
        renderer.popMatrix();
        renderer.popMatrix();
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getChestTexture(IBlockState state, BlockPos pos, boolean isChristmas) {
        if (state.func_177230_c() instanceof BlockEnderChest) {
            return ENDER_CHEST_TEXTURE;
        }
        if (isChristmas) {
            return TEXTURE_CHRISTMAS;
        }
        BlockChest chest = (BlockChest)state.func_177230_c();
        if (chest.field_149956_a == BlockChest.Type.TRAP) {
            return TEXTURE_TRAPPED;
        }
        if (chest == this.QUARK_CHEST || chest == this.QUARK_CHEST_TRAP) {
            String type;
            NBTTagCompound tag = TileEntityHelper.get_tileEntity(Registry.INFO.getWorld(), pos);
            if (tag != null && tag.func_74764_b("type") && (type = tag.func_74779_i("type")) != null && !type.equals("")) {
                return new ResourceLocation("quark", "textures/blocks/chests/" + type + ".png");
            }
        } else if (chest == this.IRON_CHEST) {
            int meta = chest.func_176201_c(state);
            String s = "";
            switch (meta) {
                case 0: {
                    s = "iron";
                    break;
                }
                case 1: {
                    s = "gold";
                    break;
                }
                case 2: {
                    s = "diamond";
                    break;
                }
                case 3: {
                    s = "copper";
                    break;
                }
                case 4: {
                    s = "silver";
                    break;
                }
                case 5: {
                    s = "crystal";
                    break;
                }
                case 6: {
                    s = "obsidian";
                    break;
                }
                case 7: {
                    s = "dirt";
                }
            }
            if (!s.equals("")) {
                return new ResourceLocation("ironchest", "textures/model/chest/" + s + "_chest.png");
            }
        }
        return TEXTURE_NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    private int getChestFacing(IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == this.IRON_CHEST) {
            NBTTagCompound tag = TileEntityHelper.get_tileEntity(Registry.INFO.getWorld(), pos);
            if (tag != null && tag.func_74764_b("facing")) {
                return tag.func_74771_c("facing");
            }
            return 0;
        }
        return block.func_176201_c(state);
    }
}

