/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstoneAPI.Events;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import sandro.Core.PatchLibrary.Field.Field;
import sandro.Core.PatchLibrary.Field.IFieldProvider;

public class TileEntityEvent
extends Event {
    private final World world;
    private final BlockPos pos;
    private final IFieldProvider tileEntity;

    public TileEntityEvent(World world, BlockPos pos, IFieldProvider tileEntity) {
        this.world = world;
        this.pos = pos;
        this.tileEntity = tileEntity;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public <T> boolean hasField(Field<T> field) {
        return this.tileEntity.hasField(field);
    }

    public <T> T getField(Field<T> field) {
        return this.tileEntity.getField(field);
    }

    public <T> void setField(Field<T> field, T value) {
        this.tileEntity.setField(field, value);
    }

    public class TileEntityWriteToNBTEvent
    extends TileEntityEvent {
        private final NBTTagCompound nbt;

        public TileEntityWriteToNBTEvent(World world, BlockPos pos, IFieldProvider tileEntity, NBTTagCompound nbt) {
            super(world, pos, tileEntity);
            this.nbt = nbt;
        }

        public NBTTagCompound getNBTTagCompound() {
            return this.nbt;
        }
    }

    public class TileEntityReadFromNBTEvent
    extends TileEntityEvent {
        private final NBTTagCompound nbt;

        public TileEntityReadFromNBTEvent(World world, BlockPos pos, IFieldProvider tileEntity, NBTTagCompound nbt) {
            super(world, pos, tileEntity);
            this.nbt = nbt;
        }

        public NBTTagCompound getNBTTagCompound() {
            return this.nbt;
        }
    }
}

