/*
 * Decompiled with CFR 0.152.
 */
package sandro.RedstoneAPI.Events;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private final IBlockAccess world;
    private IBlockState state;
    private final BlockPos pos;

    public BlockEvent(IBlockAccess world, IBlockState state, BlockPos pos) {
        this.world = world;
        this.state = state;
        this.pos = pos;
    }

    public IBlockAccess getWorld() {
        return this.world;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public static class CanBeConnectedToEvent
    extends BlockEvent {
        private final EnumFacing side;
        private boolean connected = false;

        public CanBeConnectedToEvent(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
            super(world, state, pos);
            this.side = side;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public void setConnected(boolean isConnected) {
            this.connected = isConnected;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }

    public static class CanConnectRedstoneEvent
    extends BlockEvent {
        private final EnumFacing side;
        private boolean connected = false;

        public CanConnectRedstoneEvent(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
            super(world, state, pos);
            this.side = side;
            this.connected = state.func_185897_m() && side != null;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public void setConnected(boolean isConnected) {
            this.connected = isConnected;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }

    public static class IsNormalCubeEvent
    extends BlockEvent {
        private boolean isNormal;

        public IsNormalCubeEvent(IBlockAccess world, IBlockState state, BlockPos pos) {
            super(world, state, pos);
        }

        public void setIsNormalCube(boolean isNormal) {
            this.isNormal = isNormal;
        }

        public boolean isNormalCube() {
            return this.isNormal;
        }
    }

    public static class SideIsSolidEvent
    extends BlockEvent {
        private final EnumFacing side;
        private boolean isSolid = false;

        public SideIsSolidEvent(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
            super(world, state, pos);
            this.side = side;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public void setSideSolid(boolean isSolid) {
            this.isSolid = isSolid;
        }

        public boolean isSideSolid() {
            return this.isSolid;
        }
    }

    public static class LightValueEvent
    extends BlockEvent {
        private int lightValue;

        public LightValueEvent(IBlockAccess world, IBlockState state, BlockPos pos, int lightValue) {
            super(world, state, pos);
            this.lightValue = lightValue;
        }

        public int getLightValue() {
            return this.lightValue;
        }

        public void setLightValue(int lightValue) {
            this.lightValue = lightValue;
        }
    }

    public static class NeighborChangedEvent
    extends BlockEvent {
        private final Block blockIn;
        private final BlockPos fromPos;

        public NeighborChangedEvent(IBlockAccess world, IBlockState state, BlockPos pos, Block blockIn, BlockPos fromPos) {
            super(world, state, pos);
            this.blockIn = blockIn;
            this.fromPos = fromPos;
        }

        public Block getChangedNeighborBlock() {
            return this.blockIn;
        }

        public BlockPos getChangedNeighborBlockPos() {
            return this.fromPos;
        }
    }

    public static class OnBlockActivatedEvent
    extends BlockEvent {
        private final EnumFacing facing;
        private final EntityPlayer player;
        private final EnumHand hand;
        private final float hitX;
        private final float hitY;
        private final float hitZ;
        private boolean activated = false;

        public OnBlockActivatedEvent(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing, EntityPlayer player, EnumHand hand, float hitX, float hitY, float hitZ) {
            super(world, state, pos);
            this.facing = facing;
            this.player = player;
            this.hand = hand;
            this.hitX = hitX;
            this.hitY = hitY;
            this.hitZ = hitZ;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public EnumHand getHand() {
            return this.hand;
        }

        public float getHitX() {
            return this.hitX;
        }

        public float getHitY() {
            return this.hitY;
        }

        public float getHitZ() {
            return this.hitZ;
        }

        public void setActivated() {
            this.activated = true;
        }

        public boolean isActivated() {
            return this.activated;
        }
    }

    public static class OnBlockAddedEvent
    extends BlockEvent {
        public OnBlockAddedEvent(IBlockAccess world, IBlockState state, BlockPos pos) {
            super(world, state, pos);
        }
    }

    public static class BlockStateForPlacementEvent
    extends BlockEvent {
        private final EnumFacing facing;
        private final float hitX;
        private final float hitY;
        private final float hitZ;
        private final EntityLivingBase placer;

        public BlockStateForPlacementEvent(IBlockAccess world, IBlockState defaultState, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
            super(world, defaultState, pos);
            this.facing = facing;
            this.hitX = hitX;
            this.hitY = hitY;
            this.hitZ = hitZ;
            this.placer = placer;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public float getHitX() {
            return this.hitX;
        }

        public float getHitY() {
            return this.hitY;
        }

        public float getHitZ() {
            return this.hitZ;
        }

        public EntityLivingBase getPlacer() {
            return this.placer;
        }

        public void setBlockState(IBlockState state) {
            ((BlockEvent)this).state = state;
        }
    }

    public static class BlockCanPlaceEvent
    extends BlockEvent {
        private boolean canPlace;
        private final EnumFacing side;

        public BlockCanPlaceEvent(IBlockAccess world, IBlockState defaultState, BlockPos pos, @Nullable EnumFacing side) {
            super(world, defaultState, pos);
            this.side = side;
        }

        public void setCanPlaceBlock(boolean canPlace) {
            this.canPlace = canPlace;
        }

        public boolean canPlaceBlock() {
            return this.canPlace;
        }

        @Nullable
        public EnumFacing getSide() {
            return this.side;
        }
    }
}

