/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchLibrary.Config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class ConfigHandler {
    private Configuration config;
    private String ver;
    private String fname;
    private String category = null;
    private ArrayList<String> order = new ArrayList();

    public ConfigHandler(String filename, String version) {
        this.fname = filename + ".cfg";
        this.ver = version;
    }

    public String getDefinedConfigVersion() {
        return this.config.getDefinedConfigVersion();
    }

    public String getLoadedConfigVersion() {
        return this.config.getLoadedConfigVersion();
    }

    public void loadFile() {
        File dir = ConfigHandler.getConfigDir();
        dir.mkdirs();
        this.config = new Configuration(new File(dir.getPath(), this.fname), this.ver);
        this.load();
        this.loadModules();
        this.config.save();
    }

    public static File getMcDir() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && server.func_71262_S()) {
            return new File(".");
        }
        return Minecraft.func_71410_x().field_71412_D;
    }

    public static File getConfigDir() {
        String mcdir = ConfigHandler.getMcDir().toString();
        return new File(mcdir + "/config");
    }

    public void load() {
    }

    public void loadModules() {
    }

    public void addCategory(String name, String comment) {
        if (this.category != null) {
            this.config.setCategoryPropertyOrder(this.category, this.order);
        }
        this.config.addCustomCategoryComment(name, comment);
        this.category = name;
        this.order = new ArrayList();
    }

    public boolean getBool(String name, boolean value, String comment) {
        this.order.add(name);
        return this.config.getBoolean(name, this.category, value, comment);
    }

    public int getInt(String name, int value, int min, int max, String comment) {
        this.order.add(name);
        return this.config.getInt(name, this.category, value, min, max, comment);
    }

    public float getFloat(String name, float value, float min, float max, String comment) {
        this.order.add(name);
        return this.config.getFloat(name, this.category, value, min, max, comment);
    }

    public String getString(String name, String value, String comment) {
        this.order.add(name);
        return this.config.getString(name, this.category, value, comment);
    }

    public String[] getStringArray(String name, String[] value, String comment) {
        this.order.add(name);
        return this.config.getStringList(name, this.category, value, comment);
    }

    public ArrayList<String> getStringList(String name, String[] value, String comment) {
        String[] s = this.getStringArray(name, value, comment);
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            l.add(s[i]);
        }
        return l;
    }

    public ArrayList<String> getStringList(String name, List<String> value, String comment) {
        return this.getStringList(name, (String[])value.toArray(), comment);
    }
}

