/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchAPI.Properties;

import java.io.File;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import sandro.Core.PatchAPI.Properties.BlockPropertiesDefault;
import sandro.Core.PatchAPI.Properties.IBlockProperties;
import sandro.Core.PatchAPI.Properties.PropertiesFile;
import sandro.Core.PatchRegistry.Registry;

public class PropertiesRegistry {
    public static final IBlockProperties defaultProperties = new BlockPropertiesDefault();
    private static HashMap<Block, IBlockProperties> blockMap = new HashMap();
    private static HashMap<Integer, HashMap<Block, IBlockProperties>> blockMetaMap = new HashMap();

    public static void init(File file) {
        File propertiesFile = new File(Registry.INFO.getConfigDir() + "/" + file);
        if (propertiesFile.exists()) {
            new PropertiesFile(propertiesFile);
        }
    }

    public static void registerBlockProperties(Block block, IBlockProperties properties) {
        if (blockMap.containsKey(block)) {
            blockMap.remove(block);
        }
        blockMap.put(block, properties);
    }

    public static void registerBlockProperties(Block block, int meta, IBlockProperties properties) {
        if (meta >= 0 && meta <= 15) {
            HashMap<Block, IBlockProperties> map;
            if (!blockMetaMap.containsKey(meta)) {
                blockMetaMap.put(meta, new HashMap());
            }
            if ((map = blockMetaMap.get(meta)).containsKey(block)) {
                map.remove(block);
            }
            map.put(block, properties);
        } else {
            PropertiesRegistry.registerBlockProperties(block, properties);
        }
    }

    public static IBlockProperties getBlockProperties(Block block, int meta) {
        HashMap<Block, IBlockProperties> map;
        if (blockMetaMap.containsKey(meta) && (map = blockMetaMap.get(meta)).containsKey(block)) {
            return map.get(block);
        }
        if (blockMap.containsKey(block)) {
            return blockMap.get(block);
        }
        return defaultProperties;
    }

    public static IBlockProperties getBlockProperties(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return PropertiesRegistry.getBlockProperties(block, meta);
    }

    public static IBlockProperties.EnumPushReaction getPushReaction(IBlockState state) {
        IBlockProperties properties = PropertiesRegistry.getBlockProperties(state);
        return properties.getPushReaction(state);
    }

    public static IBlockProperties.EnumRotationReaction getRotationReaction(IBlockState state) {
        IBlockProperties properties = PropertiesRegistry.getBlockProperties(state);
        return properties.getRotationReaction(state);
    }

    public static float getWeight(IBlockState state) {
        IBlockProperties properties = PropertiesRegistry.getBlockProperties(state);
        return properties.getWeight(state);
    }

    public static boolean isGravityAffected(IBlockState state) {
        IBlockProperties properties = PropertiesRegistry.getBlockProperties(state);
        return properties.isGravityAffected(state);
    }

    public static EnumFacing getAttachedSide(IBlockState state) {
        IBlockProperties properties = PropertiesRegistry.getBlockProperties(state);
        return properties.getAttachedSide(state);
    }
}

