/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.PatchAPI.Properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.minecraft.block.Block;
import sandro.Core.PatchAPI.Properties.BlockPropertiesConfig;
import sandro.Core.PatchAPI.Properties.IBlockProperties;
import sandro.Core.PatchRegistry.Registry;

public class PropertiesFile {
    private BlockPropertiesConfig blockProperties;
    private Block block;
    private int meta;

    public PropertiesFile(File file) {
        try {
            FileReader reader = new FileReader(file);
            EnumReadLevel level = EnumReadLevel.type;
            String type = "";
            String namespace = "";
            String name = "";
            String meta = "";
            String property = "";
            String value = "";
            boolean comment = false;
            boolean error = false;
            int i = 0;
            while ((i = reader.read()) != -1) {
                char c = (char)i;
                switch (this.getCharType(c)) {
                    case normal: {
                        switch (level) {
                            case type: {
                                type = type + c;
                                break;
                            }
                            case namespace: {
                                namespace = namespace + c;
                                break;
                            }
                            case name: {
                                name = name + c;
                                break;
                            }
                            case meta: {
                                meta = meta + c;
                                break;
                            }
                            case property: {
                                property = property + c;
                                break;
                            }
                            case value: {
                                value = value + c;
                            }
                        }
                    }
                    case whitespace: {
                        switch (level) {
                            case type: {
                                level = EnumReadLevel.namespace;
                                break;
                            }
                            case namespace: {
                                name = namespace;
                                namespace = "minecraft";
                            }
                            case name: {
                                level = EnumReadLevel.meta;
                            }
                        }
                    }
                    case comment: {
                        comment = true;
                        break;
                    }
                    case newline: {
                        comment = false;
                        break;
                    }
                    case colon: {
                        if (level == EnumReadLevel.namespace) {
                            level = EnumReadLevel.name;
                            break;
                        }
                        if (level != EnumReadLevel.property || error) break;
                        level = EnumReadLevel.value;
                        break;
                    }
                    case semicolon: {
                        if (level != EnumReadLevel.value || error) break;
                        this.injectProperty(property, value);
                        level = EnumReadLevel.property;
                        property = "";
                        value = "";
                        break;
                    }
                    case bracket_open: {
                        error = !this.setupType(type, namespace, name, meta);
                        level = EnumReadLevel.property;
                        break;
                    }
                    case bracket_close: {
                        level = EnumReadLevel.type;
                        type = "";
                        namespace = "";
                        name = "";
                        meta = "";
                        property = "";
                        value = "";
                    }
                }
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EnumCharType getCharType(char c) {
        switch (c) {
            case ':': {
                return EnumCharType.colon;
            }
            case ';': {
                return EnumCharType.semicolon;
            }
            case '{': {
                return EnumCharType.bracket_open;
            }
            case '}': {
                return EnumCharType.bracket_close;
            }
            case '#': {
                return EnumCharType.comment;
            }
            case '\n': {
                return EnumCharType.newline;
            }
        }
        if (Character.isLetter(c) || Character.isDigit(c)) {
            return EnumCharType.normal;
        }
        return EnumCharType.whitespace;
    }

    private boolean setupType(String type, String namespace, String name, String meta) {
        if (type.equals("block")) {
            this.block = Registry.PATCH.getBlockFromName(namespace + ":" + name);
            this.blockProperties = new BlockPropertiesConfig();
            this.meta = this.getMeta(meta);
            return true;
        }
        return false;
    }

    private int getMeta(String meta) {
        switch (meta) {
            case "0": {
                return 0;
            }
            case "1": {
                return 1;
            }
            case "2": {
                return 2;
            }
            case "3": {
                return 3;
            }
            case "4": {
                return 4;
            }
            case "5": {
                return 5;
            }
            case "6": {
                return 6;
            }
            case "7": {
                return 7;
            }
            case "8": {
                return 8;
            }
            case "9": {
                return 9;
            }
            case "10": {
                return 10;
            }
            case "11": {
                return 11;
            }
            case "12": {
                return 12;
            }
            case "13": {
                return 13;
            }
            case "14": {
                return 14;
            }
            case "15": {
                return 15;
            }
        }
        return -1;
    }

    private void injectProperty(String property, String value) {
        block7 : switch (property) {
            case "movement": {
                switch (value) {
                    case "normal": {
                        this.blockProperties.setPushReaction(IBlockProperties.EnumPushReaction.normal);
                        break block7;
                    }
                    case "immovable": {
                        this.blockProperties.setPushReaction(IBlockProperties.EnumPushReaction.immovable);
                        break block7;
                    }
                    case "destroyable": {
                        this.blockProperties.setPushReaction(IBlockProperties.EnumPushReaction.destroyable);
                        break block7;
                    }
                    case "push_only": {
                        this.blockProperties.setPushReaction(IBlockProperties.EnumPushReaction.push_only);
                        break block7;
                    }
                }
                break;
            }
            case "rotation": {
                switch (value) {
                    case "all": {
                        this.blockProperties.setRotationReaction(IBlockProperties.EnumRotationReaction.all);
                        break block7;
                    }
                    case "horizontal": {
                        this.blockProperties.setRotationReaction(IBlockProperties.EnumRotationReaction.horizontal);
                        break block7;
                    }
                    case "none": {
                        this.blockProperties.setRotationReaction(IBlockProperties.EnumRotationReaction.none);
                        break block7;
                    }
                }
                break;
            }
            case "weight": {
                break;
            }
            case "gravity": {
                switch (value) {
                    case "true": {
                        this.blockProperties.setGravityAffected(true);
                        break;
                    }
                    case "false": {
                        this.blockProperties.setGravityAffected(false);
                        break;
                    }
                }
            }
            case "attached": {
                switch (value) {
                    case "none": {
                        this.blockProperties.setAttachedSide(BlockPropertiesConfig.EnumAttachedSide.none);
                        break block7;
                    }
                    case "down": {
                        this.blockProperties.setAttachedSide(BlockPropertiesConfig.EnumAttachedSide.down);
                        break block7;
                    }
                    case "facing": {
                        this.blockProperties.setAttachedSide(BlockPropertiesConfig.EnumAttachedSide.facing);
                        break block7;
                    }
                    case "opposite": {
                        this.blockProperties.setAttachedSide(BlockPropertiesConfig.EnumAttachedSide.opposite);
                        break block7;
                    }
                }
            }
        }
    }

    private static enum EnumCharType {
        normal,
        whitespace,
        comment,
        colon,
        semicolon,
        bracket_open,
        bracket_close,
        newline;

    }

    private static enum EnumReadLevel {
        type,
        namespace,
        name,
        meta,
        property,
        value;

    }
}

